block('b-dynamic-media-creative')(

    elem('field').content()(function() {
        return [
            {
                elem: 'field-title',
                content: this.ctx.fieldTitle
            },
            {
                elem: 'field-value',
                elemMods: { name: this.elemMods.name },
                content: this.ctx.fieldData
            }
        ];
    }),

    elem('field').elemMod('name', 'id')(
        match(function() { return !(this.elemMods.deprecated === 'yes') }).def()(function() {
            return applyNext({
                'ctx.fieldTitle': iget2('b-dynamic-media-creative', 'nomer-kreativa', 'Номер креатива'),
                'ctx.fieldData': [
                    u.highlight(this.ctx.data.creative_id.toString(), this.ctx.search, {
                        global: false,
                        decorator: function(search) {
                            return {
                                block: 'b-dynamic-media-creative',
                                elem: 'hlted',
                                content: search
                            };
                        }
                    })
                ]
            });
        }),

        match(function() { return this.elemMods.deprecated === 'yes' }).def()(function() {
            return applyNext({
                'ctx.fieldTitle': iget2('b-dynamic-media-creative', 'nomer-kreativa', 'Номер креатива'),
                'ctx.fieldData': [
                    u.highlight(this.ctx.data.creative_id.toString(), this.ctx.search, {
                        global: false,
                        decorator: function(search) {
                            return {
                                block: 'b-dynamic-media-creative',
                                elem: 'hlted',
                                content: search
                            };
                        }
                    }),
                    {
                        block: 'icon',
                        mods: { 'size-12': 'alert' },
                        mix: [
                            {
                                block: 'b-dynamic-media-creative',
                                elem: 'deprecated-icon'
                            },
                            {
                                block: 'b-hintable',
                                js: {
                                    hint: iget2(
                                        'b-dynamic-media-creative',
                                        'kreativ-smart-bannera-predydushchey-no-edit',
                                        'Креатив смарт-баннера предыдущей версии. Вы не можете его редактировать. Создавать новые можно только в новой версии конструктора.'
                                    )
                                }
                            }
                        ]
                    }
                ]
            });
        })
    ),

    elem('field').elemMod('name', 'alt').def()(function() {
        return applyNext({
            'ctx.fieldTitle': iget2('b-dynamic-media-creative', 'alt-tekst', 'Alt-текст'),
            'ctx.fieldData': u.escapeHTML(u.hellipCut(this.ctx.data.altText, 255))
        });
    }),

    elem('field').elemMod('name', 'shows').def()(function() {
        return this.ctx.data.shows ?
            applyNext({
                'ctx.fieldTitle': iget2('b-dynamic-media-creative', 'pokazy', 'Показы'),
                'ctx.fieldData': this.ctx.data.shows
            }) :
            '';
    }),

    elem('field').elemMod('name', 'size').def()(function() {
        return applyNext({
            'ctx.fieldTitle': iget2('b-dynamic-media-creative', 'polnyy-razmer', 'Полный размер'),
            'ctx.fieldData': u['b-dynamic-media-creative'].getCreativeSize(this.ctx.data.width, this.ctx.data.height)
        });
    }),

    elem('field').elemMod('name', 'title').def()(function() {
        var groupName = this.ctx.data.group_name,
            bannerName = this.ctx.data.name,
            title = u._.filter([groupName, bannerName]).join(', ');

        return applyNext({
            'ctx.fieldTitle': iget2('b-dynamic-media-creative', 'nazvanie', 'Название'),
            'ctx.fieldData': u.highlight(u.escapeHTML(u.hellipCut(title, 255)), this.ctx.search, {
                global: false, decorator: function(search) {
                    return {
                        block: 'b-dynamic-media-creative', elem: 'hlted', content: search
                    };
                }
            })
        });
    }),

    elem('field').elemMod('name', 'usage-popup').def()(function() {
        return this.ctx.data.campaigns.length ?
            applyNext({
                'ctx.fieldTitle': iget2('b-dynamic-media-creative', 'v-kampaniyah', 'В кампаниях'),
                'ctx.fieldData': {
                    block: 'b-dynamic-media-creative',
                    elem: 'camps-popup',
                    elemMods: !(this.ctx.data.campaigns && this.ctx.data.campaigns.length) && { margin: 'yes' },
                    campaigns: this.ctx.data.campaigns
                }
            }) :
            '';
    }),

    elem('field').elemMod('name', 'usage-list').def()(function() {
        return this.ctx.data.campaigns.length ?
            applyNext({
                'ctx.fieldTitle': iget2('b-dynamic-media-creative', 'v-kampaniyah', 'В кампаниях'),
                'ctx.fieldData': {
                    block: 'b-dynamic-media-creative',
                    elem: 'camps-list',
                    items: this.ctx.data.campaigns,
                    ulogin: this.ctx.ulogin
                }
            }) :
            '';
    }),

    elem('field').elemMod('name', 'href').def()(function() {
        return applyNext({
            'ctx.fieldTitle': iget2('b-dynamic-media-creative', 'ssylka', 'Ссылка'),
            'ctx.fieldData': {
                block: 'link',
                target: '_blank',
                mix: {
                    block: 'b-dynamic-media-creative',
                    elem: 'link'
                },
                mods: { outer: 'yes' },
                url: this.ctx.data.href,
                content: u.escapeHTML(this.ctx.data.href)
            }
        });
    }),

    elem('field').elemMod('name', 'status').def()(function() {
        return applyNext({
            'ctx.fieldTitle': iget2('b-dynamic-media-creative', 'status-moderacii', 'Статус модерации'),
            'ctx.fieldData': {
                elem: 'status-text',
                hasReasons: this.ctx.data.rejectReasons.length,
                type: this.ctx.data.status.toLowerCase()
            }
        });
    }),

    elem('field').elemMod('name', 'banner-id').def()(function() {
        return applyNext({
            'ctx.fieldTitle': iget2('b-dynamic-media-creative', 'nomer-bannera', 'Номер баннера'),
            'ctx.fieldData': this.ctx.data.bid
        });
    }),

    elem('field').elemMod('name', 'type').match(function() {
        return !!this.ctx.data.bs_template_name && this.elemMods.deprecated === 'yes';
    }).content()(function() {
        return [
            {
                elem: 'field-title',
                content: iget2('b-dynamic-media-creative', 'tip-bannera', 'Тип баннера')
            },
            {
                elem: 'field-value',
                elemMods: { name: 'type' },
                attrs: { title: this.ctx.data.bs_template_name },
                content: this.ctx.data.bs_template_name
            }
        ];
    }),

    elem('field').elemMod('name', 'type').match(function() {
        return !this.ctx.data.bs_template_name || this.elemMods.deprecated !== 'yes';
    }).def()(function() {
        return '';
    }),

    elem('field').elemMod('name', 'geo').content()(function() {
        var geoNames = this.ctx.data.geo_names;

        return geoNames ?
            applyNext({
                'ctx.fieldTitle': iget2('b-dynamic-media-creative', 'regiony-pokaza', 'Регионы показа'),
                'ctx.fieldData': {
                    block: 'b-group-regions',
                    geoNames: geoNames || '',
                    count: geoNames.split(',').length,
                    exceptions: {}
                }
            }) :
            '';
    }),

    elem('field').elemMod('name', 'business-type').content()(function() {
        return [
            {
                elem: 'field-title',
                content: iget2('b-dynamic-media-creative', 'tip-biznesa', 'Тип бизнеса')
            },
            {
                elem: 'field-value',
                elemMods: { name: 'type' },
                attrs: { title: u._.get(u.consts('BUSINESS_TYPES'), [this.ctx.data.business_type, 'name']) || '' },
                content: u._.get(u.consts('BUSINESS_TYPES'), [this.ctx.data.business_type, 'name']) || '&mdash;'
            }
        ];
    }),

    elem('field').elemMod('name', 'theme').content()(function() {
        return [
            {
                elem: 'field-title',
                content: iget2('b-dynamic-media-creative', 'tematika', 'Тематика')
            },
            {
                elem: 'field-value',
                elemMods: { name: 'type' },
                attrs: { title: this.ctx.data.theme || '' },
                content: this.ctx.data.theme || '&mdash;'
            }
        ];
    }),

    elem('field').elemMod('name', 'layout').content()(function() {
        return [
            {
                elem: 'field-title',
                content: iget2('b-dynamic-media-creative', 'maket', 'Макет')
            },
            {
                elem: 'field-value',
                elemMods: { name: 'type' },
                attrs: { title: this.ctx.data.layout || '' },
                content: this.ctx.data.layout || '&mdash;'
            }
        ];
    })

);
