block('b-dynamic-media-creative').mod('view', 'multiedit')(

    content()(function() {
        var creative = this.ctx.creative,
            previewScale = creative.preview_scale || 1;

        return [
            {
                elem: 'data',
                content: [
                    (this.ctx.bid ? ['id', 'banner-id', 'title'] : ['id', 'title']).map(function(item) {
                        return {
                            block: 'b-dynamic-media-creative',
                            mods: { view: 'multiedit' },
                            elem: 'field',
                            data: u._.extend({
                                bid: this.ctx.bid
                            }, creative),
                            search: this.ctx.search,
                            elemMods: { name: item }
                        };
                    }, this)
                ]
            },
            {
                elem: 'side',
                content: [
                    {
                        elem: 'media-size',
                        content: u['b-dynamic-media-creative'].getCreativeSize(creative.width, creative.height)
                    },
                    {
                        elem: 'media',
                        image: creative.preview_url,
                        alt: creative.altText,
                        width: creative.width * previewScale,
                        height: creative.height * previewScale
                    }
                ]
            }
        ];
    }),

    elem('field').elemMod('name', 'id').content()(function() {
        return [
            {
                elem: 'field-title',
                content: iget2('b-dynamic-media-creative', 'nomer-kreativa', 'Номер креатива')
            },
            {
                elem: 'field-value',
                elemMods: { name: 'id' },
                content: [
                    u.highlight(this.ctx.data.creative_id.toString(), this.ctx.search, {
                        global: false,
                        decorator: function(search) {
                            return {
                                block: 'b-dynamic-media-creative',
                                elem: 'hlted',
                                content: search
                            };
                        }
                    })
                ]
            }
        ];
    }),

    elem('field').elemMod('name', 'banner-id').content()(function() {
        return [
            {
                elem: 'field-title',
                content: iget2('b-dynamic-media-creative', 'nomer-smart-bannera', 'Номер смарт-баннера')
            },
            {
                elem: 'field-value',
                elemMods: { name: 'banner-id' },
                content: this.ctx.data.bid
            }
        ];
    })

);
