block('b-dynamic-media-creative')(
    def()(function() {
        return applyNext({
            'mods.deprecated': u['b-dynamic-media-creative'].isDeprecated(this.ctx.creative) ?
                'yes' :
                this.mods.deprecated,
            campsLimit: 5
        });
    }),

    js()(function() {
        return {
            modelParams: {
                name: 'b-dynamic-media-creative',
                id: this.ctx.creative.creative_id,
                data: this.ctx.creative
            }
        };
    }),

    content()(function() {
        var creative = this.ctx.creative,
            previewScale = creative.preview_scale || 1,
            fields = ['id', 'status', 'title', 'layout','size', 'shows', 'type', 'theme', 'business-type',
                'usage-popup', 'geo'];

        return [
            {
                elem: 'data',
                content: fields.map(function(item) {
                    return {
                        block: 'b-dynamic-media-creative',
                        elem: 'field',
                        data: creative,
                        search: this.ctx.search,
                        ulogin: this.ctx.ulogin,
                        elemMods: { name: item, deprecated: this.mods.deprecated }
                    };
                }, this)
            },
            {
                elem: 'side',
                content: [
                    {
                        elem: 'media',
                        image: creative.preview_url,
                        alt: creative.altText,
                        width: creative.width * previewScale,
                        height: creative.height * previewScale
                    },
                    !this.ctx.notEditable && {
                        elem: 'controls',
                        controlsType: this.ctx.controlsType,
                        creative: creative
                    }
                ]
            }
        ];
    })
);
