BEM.DOM.decl({ block: 'b-dynamic-media-creative', baseBlock: 'i-glue' }, {
    onSetMod: {
        js: function() {
            this.__base();

            this._dynamicMediaBanners = this.findBlockOutside('p-dynamic-media-banners');

            this._initEvents();
        }
    },

    /**
     * Инициализирует события блока
     * @private
     */
    _initEvents: function() {
        this._subscriptionManager = BEM.create('i-subscription-manager');

        this._subscriptionManager.wrap(this.model)
            .on('isExpanded', 'change', function(e, data) {
                var rest = this.elem('camps-list-item').slice(this.model.get('campsLimit'));

                this.toggleMod(rest, 'hidden', 'yes', !data.value);
                this._updateBtnView(data.value);
            }, this)
            .on('isReasonsShown', 'change', function() {
                this._togglePopup();
            }, this);

        this._subscriptionManager.wrap(this._getPopup())
            .on('hide', function() {
                this.model.set('isReasonsShown', false);
            }, this)
            .on('show', this.loadPopupContent, this);
    },

    _onEditBtnClick: function() {
        if (this.model.get('campaigns').length()) {
            BEM.blocks['b-confirm'].open({
                message: iget2('b-dynamic-media-creative', 'edit-creatives-warning', 'Креативы изменятся во всех кампаниях, к которым привязаны'),
                onYes: function() {
                    this._openSmartCreativeConstructor();

                    BEM.blocks['b-metrika2'] && BEM.blocks['b-metrika2'].params({
                        params: {
                            showCreatives: {
                                clickEditCreativeButtonWithCampaigns: true
                            }
                        }
                    });
                }.bind(this)
            });
        } else {
            this._openSmartCreativeConstructor();

            BEM.blocks['b-metrika2'] && BEM.blocks['b-metrika2'].params({
                params: {
                    showCreatives: {
                        clickEditCreativeButton: true
                    }
                }
            });
        }
    },

    _openSmartCreativeConstructor: function() {
        var creativesPopup = BEM.blocks['b-dynamic-media-creatives-popup'],
            params = this.elemParams(this._getEditBtn().domElem);

        this._dynamicMediaBanners ? this._dynamicMediaBanners._openSmartCreativeConstructorModal(
            false,
            function() {
                creativesPopup.show({
                    ids: [params.creativeId]
                });
            },
            [params.creativeId]
        ) : creativesPopup.show({
            ids: [params.creativeId]
        });
    },

    _togglePopup: function() {
        var popup = this._getPopup(),
            more = this.elem('status-text-more');

        if (!popup.isShown() || popup.getOwner() != more) {
            popup.setContent($(BEMHTML.apply({
                block: 'spin',
                js: true,
                mix: [
                    { block: 'b-dynamic-media-creative', elem: 'spin' },
                    { block: 'b-dynamic-media-creative', elem: 'popup-content' }
                ],
                mods: { progress: 'yes', theme: 'gray-48' }
            })));
        }

        popup.toggle(more);

        return this;
    },

    /**
     * Отправляет запрос на загрузку содержимого попапа
     * @param {Object} e
     * @param {Object} data
     * @param {BEM} data.owner
     * @returns {BEM}
     */
    loadPopupContent: function(e, data) {
        if (data.owner != this.elem('status-text-more')) return this;

        BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            dataType: 'json',
            callbackCtx: this
        }).get({
            cmd: 'showDiag',
            creative_id: this.model.id,
            creative_rejection_reason_ids: this.model.get('rejectReasons').join()
        }, function(data) {
            this.onPopupContentLoaded(data.creatives_diags);
        });

        return this;
    },

    /**
     * Загрузилась информация о причинах отклонения для данного креатива
     * @param {Object} diags
     * @returns {BEM}
     */
    onPopupContentLoaded: function(diags) {
        var popup = this._getPopup(),
            reasonsList = $(BEMHTML.apply({
                block: 'b-quality-verdicts-list',
                mix: [{ block: 'b-dynamic-media-creative', elem: 'popup-content' }],
                mods: { type: 'creative' },
                expandButtonTexts: { expand: iget2('b-dynamic-media-creative', 'razvernut-vsyo', 'Развернуть всё'), fold: iget2('b-dynamic-media-creative', 'svernut-vsyo', 'Свернуть всё') },
                verdicts: this.model.get('rejectReasons').map(function(el) {
                    var diag = diags[el];

                    return { title: diag.name, recommendation: diag.description };
                })
            }));

        popup.setContent(reasonsList);

        this.findBlockInside(reasonsList, 'b-quality-verdicts-list')
            .on('expand', function() { popup.repaint() });

        return this;
    },

    /**
     * Обновляет состояние кнопки "скрыть / еще - n"
     * @param {Boolean} isExpanded - флаг, раскрыт ли список кампаний
     * @private
     */
    _updateBtnView: function(isExpanded) {
        var restButton = this._getRestBtn();

        BEM.DOM.update(restButton.domElem, BEMHTML.apply({
            block: 'button',
            elem: 'text',
            content: !isExpanded ? [
                iget2('b-dynamic-media-creative', 'eshchyo', 'Ещё'),
                {
                    block: 'b-dynamic-media-creative',
                    elem: 'camps-list-rest-length',
                    limit: this.model.get('campsLimit'),
                    num: this.model.get('campaigns').length()
                }
            ] :
                iget2('b-dynamic-media-creative', 'skryt', 'Скрыть')
        }));

        restButton.toggleMod('expanded', 'yes', '', isExpanded);
    },

    /**
     * Возвращает ссылку на общий попап со списком кампаний
     * @return {BEM.DOM}
     * @private
     */
    _getCampaignsPopup: function() {
        return BEM.blocks['b-shared-popup'].getInstance(
            { animate: 'yes', 'content-adaptive': 'yes' },
            { directions: ['bottom-left', 'right'] });
    },

    /**
     * Возвращает ссылку на общий попап со списком причин отклонения
     * @return {BEM.DOM}
     * @private
     */
    _getPopup: function() {
        return this.popup || (this.popup = BEM.blocks['b-shared-popup'].getInstance(
            { size: 'xs', animate: 'no', 'has-close': 'yes', 'content-adaptive': 'yes' },
            { directions: ['right-middle-middle'] }));
    },

    /**
     * Возвращает блок кнопки "скрыть / еще - n"
     * @private
     */
    _getRestBtn: function() {
        return this._restButton || (this._restButton = this.findBlockOn('camps-list-toggle-rest', 'button'));
    },

    /**
     * Возвращает блок кнопки "Редактировать
     * @private
     */
    _getEditBtn: function() {
        return this._editButton || (this._editButton = this.findBlockOn('edit', 'button'));
    },

    /**
     * Показывает/прячет попап со списком кампаний
     * @param {BEM.DOM} button
     * @param {Object[]} campaigns
     * @private
     * @returns {BEM.DOM}
     */
    _toggleCampaignsPopup: function(button, campaigns) {
        return this._getCampaignsPopup()
            .setContent(BEMHTML.apply({
                block: 'b-dynamic-media-creative',
                elem: 'camps-popup',
                elemMods: { list: 'yes' },
                campaigns: campaigns
            }))
            .toggle(button)
    },

    /**
     * Показывает/прячет попап со списком причин отклонения
     * @param {BEM.DOM} button
     * @private
     * @returns {BEM.DOM}
     */
    _toggleRejectReasonsPopup: function(button) {
        return this._getRejectReasonsPopup()
            .setContent(BEMHTML.apply({
                block: 'b-dynamic-media-creative',
                elem: 'reasons-list',
                items: this.model.get('rejectReasons')
            }))
            .toggle(button)
    },

    /**
     * Удаляет блок, модель, подписки
     * @override
     */
    destruct: function() {
        this._subscriptionManager.dispose();
        this.model.destruct();

        this.__base.apply(this, arguments);
    }

}, {
    live: function() {
        this
            .liveBindTo('campaigns-popup-button', 'click', function(e) {
                var button = this.findBlockOn(e.data.domElem, 'button');

                if (button.isDisabled()) return;

                this._toggleCampaignsPopup(button, this.elemParams(e.data.domElem).campaigns);

            })
            .liveBindTo('camps-list-toggle-rest', 'click', function() {
                this.model.toggleExpandFlag();
            })
            .liveBindTo('status-text-more', 'click', function() {
                this.model.toggleReasonsFlag();
            })
            .liveBindTo('edit', 'click', function() {
                this._onEditBtnClick();
            });
    }
});
