u.register({
    'b-dynamic-media-creative': {
        prepareDataFromDM: function(data) {
            return {
                creative_id: data.creative_id,
                creative_group_id: data.creative_group_id || '0',
                business_type: data.business_type,
                name: data.name,
                group_name: data.group_name,
                width: data.width,
                height: data.height,
                preview_scale: data.preview_scale,
                altText: data.alt_text,
                href: data.href,
                shows: data.shows,
                geo_names: data.geo_names,
                status: data.status_moderate,
                preview_url: data.preview_url,
                rejectReasons: data.rejection_reason_ids,
                campaigns: (data.used_in_camps || []).map(function(camp) {
                    return { name: camp.campaign_name, cid: camp.id };
                }),
                bs_template_name: data.bs_template_name,
                theme_id: data.theme_id,
                layout: data.layout,
                theme: data.theme
            }
        },

        /**
         * Возвращает название размера креатива по его ширине и высоте
         * Для размера 0х0 нужно писать "Адаптивный"
         * @param {Number|String} width
         * @param {Number|String} height
         * @returns {String}
         */
        getCreativeSize: function(width, height) {
            var size;

            width = Number(width);
            height = Number(height);

            if (width === 0 && height === 0) {
                size = iget2('b-dynamic-media-creative', 'adaptivnii', 'Адаптивный');
            } else {
                size = width + 'x' + height;
            }

            return size;
        },

        /**
         * Креатив является устаревшим
         * @param {Object} creative
         * @param {String} creative.creative_group_id
         * @returns {Boolean}
         */
        isDeprecated: function(creative) {
            return creative.creative_group_id === '0';
        }
    }
});
