BEM.MODEL.decl({ name: 'b-dynamic-media-creative', baseModel: 'vm-sync-dm' }, {
    /**
     * id креатива
     */
    creative_id: 'id',

    /**
     * id группы к которой принадлежит креатив
     */
    creative_group_id: 'string',

    /**
     * Тип бизнеса к которому принадлежит креатив
     */
    business_type: 'string',

    /**
     * название - заголовок
     */
    name: 'string',

    /**
     * название группы - заголовок
     */
    group_name: 'string',

    /**
     * ширина изображения
     */
    width: 'number',

    /**
     * высота изображения
     */
    height: 'number',

    /**
     * альтернативный текст
     */
    altText: 'string',

    /**
     * ссылка
     */
    href: 'string',

    /**
     * кол-во показов
     */
    shows: 'number',

    /**
     * превью изображения
     */
    preview_url: 'string',

    /**
     * коэффициент масштабирования изображения для показа в интерфейсе
     */
    preview_scale: 'number',

    /**
     * id клиента
     */
    clientId: 'string',

    /**
     * статус-состояние креатива
     */
    status: 'string',

    /**
     * список кампаний использующих креатив
     */
    campaigns: {
        type: 'models-list',
        modelName: 'vm-dynamic-media-creative-campaign'
    },

    /**
     * декларация DM модели
     */
    _dmDecl: {
        type: 'object',
        internal: true,
        calculate: function() {
            return {
                name: 'dm-dynamic-media-creative',
                id: this.get('creative_id')
            };
        }
    },

    /**
     * Тип баннера
     */
    bs_template_name: 'string',

    /**
     * Регионы показа
     */
    geo_names: 'string',

    /**
     * список причин отклонения на модерации
     */
    rejectReasons: {
        type: 'array'
    },

    /**
     * флаг- раскрыт ли список кампаний
     */
    isExpanded: {
        type: 'boolean',
        default: false
    },

    /**
     * флаг- раскрыт ли попап причин отклонения на модерации
     */
    isReasonsShown: {
        type: 'boolean',
        default: false
    },

    /**
     * максимальное кол-во отображаемых кампаний над кнопкой 'Ещё'
     */
    campsLimit: {
        type: 'number',
        default: 5
    },

    /**
     * ID тематики
     */
    theme_id: 'string',

    /**
     * Человекочитаемое название тематики
     */
    theme: 'string'

}, {
    /**
     * Меняет значение флага isExpanded на обратное
     */
    toggleExpandFlag: function() {
        this.set('isExpanded', !this.get('isExpanded'));
    },

    /**
     * Меняет значение флага isReasonsShown на обратное
     */
    toggleReasonsFlag: function() {
        this.set('isReasonsShown', !this.get('isReasonsShown'));
    },

    /**
     * Обновляет модель данными из DM
     */
    syncFromDM: function() {
        this.__base.apply(this, arguments);

        this.get('campaigns').forEach(function(campaign) {
            campaign.syncFromDM();
        });
    },

    /**
     * Готовит данные для синхронизации из DM
     */
    prepareDataFromDM: function(data) {
        return u['b-dynamic-media-creative'].prepareDataFromDM(data);
    }
});
