/**
 * @property {Number} this.ctx.limit предел количества добавляемых объявлений
 */
block('b-dynamic-media-creatives-choose').mod('type', 'add')(
    js()(function() {
        return u._.extend(applyNext() || {}, {
            modelParams: {
                name: 'b-dynamic-media-creatives-choose',
                data: {
                    addLimit: this.ctx.limit
                }
            }
        });
    }),

    elem('banners').content()(function() {
        return [
            applyNext(),
            {
                block: 'b-creative-wrapper',
                mods: { view: 'groups', 'controls-type': 'add' },
                options: {
                    hasFilters: true,
                    hasViewSwitcher: true,
                    skipBusinessTypeFilter: true
                },
                modelData: {
                    excludeCreativeIds: this.ctx.excludeCreativeIds,
                    filters: this.ctx.filters
                }
            }
        ]
    }),

    elem('save').replace()(function() {
        return {
            block: 'button',
            mix: [
                {
                    block: 'b-dynamic-media-creatives-choose',
                    elem: 'save'
                },
                {
                    block: 'b-dynamic-media-creatives-choose',
                    elem: 'model-field',
                    js: {
                        name: 'nothingSelected',
                        type: 'mod',
                        modName: 'disabled',
                        block: 'button'
                    }
                }
            ],
            mods: {
                disabled: 'yes'
            },
            content: iget2('b-dynamic-media-creatives-choose', 'dobavit-v-gruppu', 'Добавить в группу')
        };
    })
);
