/**
 * Событие превышения предела количества выбранных креативов
 * @event b-dynamic-media-creatives-choose#limitExceeded
 * @type {Object}
 * @property {Number} limit предел количества выбранных креативов
 * @property {Number} actual количества выбранных креативов
 */

/**
 * @fires b-dynamic-media-creatives-choose#limitExceeded
 * @fires b-dynamic-media-creatives-choose#save
 */
BEM.DOM.decl({ block: 'b-dynamic-media-creatives-choose', modName: 'type', modVal: 'add' }, {
    _onSaveClick: function() {
        var limit = this.model.get('addLimit'),
            selected = this._creativeWrapper.getSelectedIds(),
            selectedCount = selected.length;

        if (selectedCount > limit) {
            this.trigger('limitExceeded', { limit: limit, actual: selectedCount });
        } else {
            this._creativeWrapper.getSelectedCreatives().then(function(result) {
                this.trigger('save', result.creatives);
            }.bind(this));
        }
    }
});
