/**
 * @property {String} this.ctx.ulogin логин пользователя, с креативами которого будут производиться операции
 * @property {Object} this.ctx.exclude параметры исключения креативов
 * @param {String} this.ctx.adgroupId идентификатор группы, креативы которой нужно исключить из списка отображаемых креативов
 * @param {String[]} this.ctx.exclude.creativeIds идентификаторы креативов, которые нужно исключить из списка отображаемых креативов
 * @param {Object} this.ctx.filters объект с фильтрами для креативов
 */
block('b-dynamic-media-creatives-choose')(
    js()(function() {
        return {
            parentPopup: this.ctx.parentPopup,
            modelData: {
                addLimit: this.ctx.limit,
                excludeCreativeIds: this.ctx.exclude.creativeIds
            }
        };
    }),

    content()(function() {
        return [
            {
                elem: 'header',
                mix: { block: 'b-modal-popup-decorator', elem: 'header' }
            },
            {
                elem: 'banners',
                excludeCreativeIds: this.ctx.exclude.creativeIds,
                leadCreativeId: this.ctx.currentBannerId,
                filters: this.ctx.filters,
                mix: { block: 'b-modal-popup-decorator', elem: 'body' }
            },
            {
                elem: 'footer',
                mix: { block: 'b-modal-popup-decorator', elem: 'footer' }
            }
        ];
    }),

    elem('header').content()(function() {
        return [
            { elem: 'title' },
            { elem: 'head-controls' }
        ];
    }),

    elem('head-controls').content()(function() {
        return {
            elem: 'storage-link'
        }
    }),

    elem('title').content()(function() {
        return iget2('b-dynamic-media-creatives-choose', 'kreativy', 'Креативы');
    }),

    elem('banners').content()(function() {
        return {
            block: 'button',
            mods: { add: 'left' },
            mix: { block: 'b-dynamic-media-creatives-choose', elem: 'add-new' },
            content: iget2('b-dynamic-media-creatives-choose', 'sozdat-novye', 'Создать новые')
        };
    }),

    elem('storage-link').content()(function() {
        return {
            block: 'link',
            target: '_blank',
            url: u.getUrl('showCreatives', {
                ulogin: u.consts('ulogin')
            }),
            content: iget2('b-dynamic-media-creatives-choose', 'pereyti-na-stranicu-kreativy', 'Перейти на страницу «Креативы для смарт-баннеров»')
        };
    }),

    elem('footer').content()([
        {
            elem: 'save'
        },
        {
            elem: 'cancel'
        },
        {
            elem: 'selected-count-message'
        }
    ]),

    elem('cancel').replace()(function() {
        return {
            block: 'button',
            mix: {
                block: 'b-dynamic-media-creatives-choose',
                elem: 'cancel'
            },
            content: iget2('b-dynamic-media-creatives-choose', 'otmena', 'Отмена')
        };
    })
);
