/**
 * Кампания, в которой используется креатив
 * @typedef CreativeCampaign
 * @type {Object}
 * @property {String} id
 * @property {String} campaign_name
 */

/**
 * Креатив
 * @typedef Creative
 * @type {Object}
 * @property {String} creative_id
 * @property {String} name
 * @property {Number} width
 * @property {Number} height
 * @property {String} alt_text
 * @property {String} href
 * @property {Number} shows
 * @property {String} preview_url
 * @property {String} status_moderate
 * @property {CreativeCampaign[]} used_in_camps
 * @property {String[]} reject_reasons
 */

/**
 * Событие запроса на сохранение выбранных креативов
 * @event b-dynamic-media-creatives-choose#save
 * @type {Creative[]|Creative}
 */

/**
 * Событие запроса "отмены" (была нажата кнопка "Отменить")
 * @event b-dynamic-media-creatives-choose#cancel
 */

/**
 * Событие окончания перерисовки содержимого блока
 * @event b-dynamic-media-creatives-choose#render:after
 */

/**
 * @fires b-dynamic-media-creatives-choose#cancel
 * @fires b-dynamic-media-creatives-choose#create
 * @fires b-dynamic-media-creatives-choose#render:after
 */
BEM.DOM.decl({
    block: 'b-dynamic-media-creatives-choose',
    baseBlock: 'i-glue',
    implements: 'i-modal-popup-inner-block-interface'
}, {
    onSetMod: {
        js: function() {
            var subscriptionManaher = this._getSubscriptionManager();

            this.__base();

            u.graspSelf.call(this, {
                _creativeWrapper: 'b-creative-wrapper inside banners',
                _addNew: 'button on add-new',
                _save: 'button on save',
                _cancel: 'button on cancel',
                _create: 'storage-link'
            });

            subscriptionManaher
                .on(this._addNew, 'click', this._showAddMediaCreativePopup, this)
                .on(this._save, 'click', this._onSaveClick, this)
                .on(this._cancel, 'click', this._onCancelClick, this);

            subscriptionManaher.wrap(this._creativeWrapper)
                .on('data-loading:start', function() {
                    this._save.setMod('disabled', 'yes');
                }, this)
                .on('data-loading:end selectedChanged', function() {
                    this.trigger('repaint');
                    this.elem('selected-count-message').text(this._creativeWrapper.getSelectedCountMessage());
                    this._save.setMod('disabled', this._creativeWrapper.getSelectedIds().length ? '' : 'yes');
                }, this);

            this.bindTo(this._create, 'click', function(e) {
                this.trigger('create');
            });
        }
    },

    isChanged: function() {
        return $.Deferred().resolve(this._creativeWrapper.isSelectedChanged()).promise();
    },

    /**
     * @override {BEM.DOM}
     */
    destruct: function() {
        this._getSubscriptionManager().dispose();

        return this.__base.apply(this, arguments);
    },

    /**
     * Реакция на добавление нового креатива
     * @private
     */
    _onNewMediaCreativeAdded: function() {
        this._getAddMediaCreativePopup().hide();
        //перерисовываем список креативов
        this._creativeWrapper.fetchDataAndRenderBlock();
    },

    /**
     * Открывает попап добавления новых креативов
     * @returns {BEM}
     * @private
     */
    _showAddMediaCreativePopup: function() {
        this._getAddMediaCreativePopup()
            .setContent(BEMHTML.apply({ block: 'b-dynamic-media-creatives-popup', js: true }))
            .show();

        return this;
    },

    /**
     * Возвращает попап создания новых креативов
     * @returns {BEM.DOM}
     * @private
     */
    _getAddMediaCreativePopup: function() {
        if (!this._popup) {
            this._popup = BEM.blocks['b-shared-popup'].getInstance({
                type: 'modal',
                adaptive: 'yes',
                disposition: 'dropdown',
                'body-scroll': 'no',
                'content-adaptive': 'yes',
                position: 'fixed',
                'has-close': 'yes',
                autoclosable: 'no'
            }, {}, {}, { type: 'paranja' });

            this._getSubscriptionManager().on(
                BEM.blocks['b-dynamic-media-creatives-popup'],
                'ad-designer-close',
                this._onNewMediaCreativeAdded,
                this
            );
        }

        return this._popup;
    },

    /**
     * Возвращает менеджер подписок
     * @returns {Object}
     * @private
     */
    _getSubscriptionManager: function() {
        return this._subscriptionManager || (this._subscriptionManager = BEM.create('i-subscription-manager'));
    },

    /**
     * Обработчик клика по кнопке "Отмена"
     * @private
     */
    _onCancelClick: function() {
        this.trigger('cancel');
    },

    /**
     * Обработчик клика по кнопке "Сохранить"
     * @private
     */
    _onSaveClick: function() {
        //implemented in subclasses
    }
});
