BEM.DOM.decl({ block: 'b-dynamic-media-creatives-popup' }, {
    onSetMod: {
        js: function() {
            u.graspSelf.call(this, {
                _iframe: 'b-iframe on iframe'
            });

            this._iframe.on('load', this._onIFrameLoaded, this);
        }
    },

    /**
     * Реакция на загрузку фрейма в блоке. Привязывает события к окну, открывшемуся в фреме
     * @private
     */
    _onIFrameLoaded: function() {
        this._getInnerWindow().addEventListener('message', function(event) {
            if (event.data == 'AdDesignerClose') {
                BEM.blocks['b-dynamic-media-creatives-popup'].trigger('ad-designer-close');
            }
        });
    },

    /**
     * Возвращает ссылку на открытое окно в iframe
     * @returns {window}
     * @static
     */
    _getInnerWindow: function() {
        var win = top[this._iframe.getName()];

        return win != null && typeof win == 'object' && !win.closed ?
            win :
            null;
    }

}, {

    /**
     * Открывает попап добавления новых креативов
     * @returns {BEM}
     * @private
     */
    show: function(options) {
        this._getAddMediaCreativePopup()
            .setContent(BEMHTML.apply({
                block: 'b-dynamic-media-creatives-popup',
                options: options,
                js: true
            }))
            .show();

        return this;
    },

    hide: function() {
        this._getAddMediaCreativePopup().hide();
    },

    _popup: null,

    /**
     * Возвращает попап создания новых креативов
     * @returns {BEM.DOM}
     * @private
     */
    _getAddMediaCreativePopup: function() {
        if (!this._popup) {
            this._popup = BEM.blocks['b-shared-popup'].getInstance({
                type: 'modal',
                adaptive: 'yes',
                disposition: 'dropdown',
                'body-scroll': 'no',
                'content-adaptive': 'yes',
                position: 'fixed',
                'has-close': 'yes',
                autoclosable: 'no'
            }, {}, {}, { type: 'paranja' });
        }

        return this._popup;
    }

});
