/**
 * @typedef {Object} EditBannerAddContext контекст блока b-edit-banner-add2
 * @property {Number} this.ctx.bannersLimit лимит на количество объявлений
 * @property {Boolean} this.ctx.isFeedSelected выбран фид или нет
 * @property {Number} this.ctx.availableToCreateBannersCount количество объявлений которые еще можно создать в группе
 * @property {String} this.ctx.mainTitle заголовок кнопки, например iget('Объявление')
 * @property {String[]} this.ctx.pluralTitles формы множественнного числа баннера/объявления/etc в описании, например [iget('объявление'), iget('объявления'), iget('объявлений')]
 */

/**
 * @property {EditBannerAddContext} this.ctx
 */
block('b-edit-banner-add2').mod('limits', 'feed')(
    js()(function() {
        return {
            modelParams: {
                name: 'b-edit-banner-add2_limits_feed',
                data: {
                    availableToCreateBannersCount: this.ctx.availableToCreateBannersCount,
                    isFeedSelected: this.ctx.isFeedSelected
                }
            },
            pluralTitles: this.ctx.pluralTitles,
            bannersLimit: this.ctx.bannersLimit
        };
    }),

    elem('text')(
        tag()('span'),

        content()(function() {
            var titles = this.ctx.pluralTitles,
                availableText = this.ctx.availableToCreateBannersCount > 0 ?
                    iget2('b-edit-banner-add2', 'v-etu-gruppu-mozhno', 'В эту группу можно добавить еще {foo}', {
                        foo: u.pluralize(titles, this.ctx.availableToCreateBannersCount)
                    }) :
                    iget2('b-edit-banner-add2', 'v-gruppu-mozhet-byt', 'В группу может быть добавлено не более {foo}', {
                        foo: u.pluralize([titles[1], titles[2], titles[2]], this.ctx.bannersLimit)
                    }); //родительный падеж
            return [
                this.ctx.isFeedSelected || iget2('b-edit-banner-add2', 'cnachala-vyberite-fid', 'Cначала выберите фид. '),
                availableText
            ];

        })
    ),

    content()(function() {
        var count = this.ctx.availableToCreateBannersCount;

        return [
            {
                elem: 'button',
                count: count,
                mainTitle: this.ctx.mainTitle
            },
            {
                elem: 'text',
                availableToCreateBannersCount: count,
                bannersLimit: this.ctx.bannersLimit,
                pluralTitles: this.ctx.pluralTitles,
                isFeedSelected: this.ctx.isFeedSelected
            }
        ];
    })
);
