BEM.DOM.decl({ block: 'b-edit-banner-add2', modName: 'limits', modVal: 'feed' }, {
    onSetMod: {
        js: function() {
            this.__base();

            this.model
                .on('isFeedSelected', 'change', function() {
                    this._refreshText();
                }, this)
        }
    },

    /**
     * Установить доступное для добавления количество объявлений
     * @param {Boolean} isSelected
     */
    setSelectedFeeds: function(isSelected) {
        this.model.set('isFeedSelected', isSelected);
    },

    /**
     * Обновляет содержимое элемента text
     */
    _refreshText: function() {
        BEM.DOM.replace(this.findElem('text'), $(BEMHTML.apply({
            block: 'b-edit-banner-add2',
            mods: { limits: 'feed' },
            elem: 'text',
            isFeedSelected: this.model.get('isFeedSelected'),
            availableToCreateBannersCount: this.model.get('availableToCreateBannersCount'),
            bannersLimit: this.params.bannersLimit,
            pluralTitles: this.params.pluralTitles
        })));
    }
});
