/**
 * @fires b-edit-banner-add2#add
 */
BEM.DOM.decl({ block: 'b-edit-banner-add2', baseBlock: 'i-glue' }, {
    onSetMod: {
        js: function() {
            this.__base();

            this._addBtn = this.findBlockOn('add-button', 'button');

            this._addBtn.on('click', function() {
                if (this.model.get('canAdd')) {
                    /**
                     * @event b-edit-banner-add2#add
                     */
                    this.trigger('add');
                }
            }, this);

            this.model
                .on('availableToCreateBannersCount', 'change', function(e, data) {
                    this._refreshText(data.value);
                }, this)
                .on('canAdd', 'change', function(e, data) {
                    this._addBtn.setMod('disabled', !data.value ? 'yes' : '');
                }, this);
        }
    },

    /**
     * Установить доступное для добавления количество объявлений
     * @param {Number} count
     */
    setAvailableToCreateBannersCount: function(count) {
        this.model.set('availableToCreateBannersCount', count);
    },

    /**
     * Обновляет содержимое элемента text
     * @param {String} val - кол-во баннеров в группе, которое еще можно создать
     */
    _refreshText: function(val) {
        BEM.DOM.replace(this.findElem('text'), $(BEMHTML.apply({
            block: 'b-edit-banner-add2',
            elem: 'text',
            availableToCreateBannersCount: val,
            bannersLimit: this.params.bannersLimit,
            pluralTitles: this.params.pluralTitles
        })));
    }
});
