block('b-edit-banner2').elem('action-type')(

    mix()([
        {
            block: 'b-edit-banner2',
            elem: 'row'
        },
        {
            block: 'b-layout-form',
            elem: 'row'
        }
    ]),

    content()(function() {
        var actionType = this.banner.primary_action,
            items = u['b-edit-banner2__action-type'].getActionTypeItems(actionType);

        return [
            {
                elem: 'label',
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'label'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: iget2('b-edit-banner2', 'knopka-deystvia', 'Кнопка действия')
            },
            {
                block: 'select',
                mix: [
                    {
                        block: 'b-edit-banner2',
                        elem: 'action-type-select'
                    },
                    {
                        block: 'b-edit-banner2',
                        elem: 'model-field',
                        js: {
                            name: 'actionType',
                            type: 'select'
                        }
                    }
                ],
                mods: {
                    size: 's',
                    theme: 'normal'
                },
                content: [
                    {
                        block: 'button',
                        content: u['b-edit-banner2__action-type'].getActionTypeName(actionType)
                    },
                    {
                        elem: 'control',
                        content: items.map(function(el) {
                            var option = {
                                elem: 'option',
                                attrs: { value: el.value },
                                content: el.text
                            };

                            el.selected && (option.attrs.selected = true);

                            return option;
                        })
                    },
                    {
                        block: 'b-help-link',
                        mods: { type: 'modal' },
                        mix: { block: 'b-edit-banner2', elem: 'action-help' },
                        stretched: true,
                        url: u.getHelpUrl('advertising-mobile-apps-button')
                    }
                ]
            }
        ];
    })
);
