block('b-edit-banner2').elem('ad-type')(

    mix()([
        {
            block: 'b-edit-banner2',
            elem: 'body-row'
        },
        {
            block: 'b-edit-banner2',
            elem: 'row'
        },
        {
            block: 'b-layout-form',
            elem: 'row'
        }
    ]),

    content()(function() {
        // активен только для новых баннеров
        var isDisabled = this.banner.bid !== 0,
            cpcRmpVideoEnabled = this.isRmpCpcVideoEnabled,
            bannerTypes = [
                { value: 'text', text: iget2('b-edit-banner2', 'tekstovo-graficheskoe', 'Текстово-графическое') },
                { value: 'image_ad', text: iget2('b-edit-banner2', 'graficheskoe', 'Графическое') }
            ];

        if ((
            this.campaign.mediaType === 'text' ||
            (this.campaign.mediaType === 'mobile_content' && cpcRmpVideoEnabled)
            ) &&
            (u.consts('rights').allowedCpcVideoBanners || this.banner.ad_type === 'cpc_video')
        ) {
            bannerTypes.push({
                value: 'cpc_video',
                text: [
                    iget2('b-edit-banner2', 'cpc-video', 'Видео')
                ]
            });
        }

        return [
            {
                elem: 'label',
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'label'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: iget2('b-edit-banner2', 'tip-obyavleniya', 'Тип объявления')
            },
            {
                elem: 'control',
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'control'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: [
                    {
                        block: 'b-edit-banner2',
                        elem: 'wrap',
                        content: isDisabled ?
                            {
                                elem: 'text-wrap',
                                content: u._.get(u._.find(bannerTypes, { value: this.banner.ad_type }), 'text')
                            } :
                            [
                                {
                                    block: 'radio-button',
                                    mods: {
                                        size: 's',
                                        disabled: isDisabled ? 'yes' : ''
                                    },
                                    mix: [{
                                        block: 'b-edit-banner2',
                                        elem: 'model-field',
                                        js: { name: 'ad_type', type: 'radio-button' }
                                    }],
                                    name: 'ad_type',
                                    value: this.banner.ad_type || 'text',
                                    content: bannerTypes.map(function(type) {
                                        return {
                                            elem: 'radio',
                                            content: type.text,
                                            controlAttrs: { value: type.value }
                                        }
                                    })
                                },
                                cpcRmpVideoEnabled && {
                                    block: 'b-beta',
                                    mods: { type: 'symbol', rmp_beta: true }
                                }
                            ]

                    }
                ]
            }
        ];
    })
);
