block('b-edit-banner2').elem('audits')(

    mix()([
        {
            block: 'b-edit-banner2',
            elem: 'row'
        },
        {
            block: 'b-layout-form',
            elem: 'row'
        }
    ]),

    js()(true),

    content()(function() {
        var items = this.ctx.audits || [],
            maxLength = 4;

        for (var i = items.length; i < maxLength; i++) {
            items.push('');
        }

        return [
            {
                elem: 'label',
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'label'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: [
                    iget2('b-edit-banner2', 'pixel-audit', 'Счётчик показов'),
                    {
                        block: 'b-help-link',
                        mods: {
                            type: 'modal'
                        },
                        stretched: true,
                        mix: [{
                            block: 'b-edit-banner2',
                            elem: 'help-icon'
                        }],
                        url: u.getHelpUrl('third-party-tracking-url')
                    }
                ]
            },
            {
                elem: 'control',
                attrs: { 'data-err-path': 'audits' } ,
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'control'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    },
                    {
                        block: 'b-edit-banner2',
                        elem: 'model-field',
                        js: {
                            name: 'audits',
                            type: 'array',
                            bindType: 'input'
                        }
                    }
                ],
                content: [
                    {
                        block: 'b-error-pretty-message',
                        js: true,
                        mods: { theme: 'classic' }
                    },
                    items.map(function(input, index) {
                        return {
                            elem: 'audit-input',
                            attrs: { 'data-err-path': index.toString() } ,
                            content: [
                                {
                                    block: 'b-error-pretty-message',
                                    js: true,
                                    mods: { theme: 'classic' }
                                },
                                {
                                    block: 'input',
                                    mix: {
                                        block: 'b-errors-presenter2',
                                        elem: 'cleaner',
                                        js: { block: 'input' }
                                    },
                                    mods: {
                                        type: 'textarea',
                                        hidden: !!index && !input
                                    },
                                    js: true,
                                    name: 'audit',
                                    value: input,
                                    content: {
                                        elem: 'control',
                                        attrs: { rows: 5 }
                                    }
                                }
                            ]
                        };
                    }),
                    {
                        block: 'button',
                        mods: {
                            'only-icon': 'yes',
                            hidden: true
                        },
                        name: 'button-add-operation',
                        mix: {
                            block: 'b-edit-banner2',
                            elem: 'button',
                            elemMods: { action: 'add-operation' },
                            js: true
                        },
                        content: {
                            block: 'icon',
                            mods: { 'size-16': 'plus' },
                            mix: {
                                block: 'button',
                                elem: 'icon'
                            }
                        }
                    }
                ]
            }
        ];
    })
);
