BEM.DOM.decl({ block: 'b-edit-banner2', elem: 'audits' }, {
    onSetMod: {
        js: function() {
            this.isFrontpageOrDeals = this._parent.model.name === 'dm-cpm-yndx-frontpage-banner' ||
                this._parent.model.name === 'dm-cpm-deals-banner';

            this._subscriptionManager = BEM.create('i-subscription-manager');

            this._addButton = this.findBlockInside(this.elem('button', 'action', 'add-operation'), 'button');
            this._inputs = this.findBlocksInside('control', 'input');

            this._updateElemByGroupType(this._parent.getMod('cpm-group-type'), this.isFrontpageOrDeals);

            this._initSubscriptions();
        },
        'cpm-group-type': function(name, val) {
            this._updateElemByGroupType(val);
        }
    },

    /*

     */
    _updateElemByGroupType: function(type, isFrontpageOrDeals) {
        if (type === 'cpm-video' && u.consts('rights').cpmVideoSeveralPixelsEnabled || type === 'cpm-banner' ||
            isFrontpageOrDeals) {
            this._updateVisibilityButton();
        } else {
            this._showAndClearHiddenInputs(1);
            this._addButton.setMod('hidden', true);
        }
    },

    /**
     * Добавление нового поля для счетчика
     * @private
     */
    _onAdd: function() {
        var inputHidden = this._inputs.find(function(input) {
            return input.hasMod('hidden', true);
        });

        if (!inputHidden) {
            return;
        }

        inputHidden.delMod('hidden');

        this._addButton.delMod('hidden');

        this._updateVisibilityButton();
    },

    /**
     * Показвает/скрывает кнопку для добавления новых полей
     * @private
     */
    _updateVisibilityButton: function() {
        var isSomeInputHidden = this._inputs.some(function(input) {
            return input.hasMod('hidden', true);
        });

        this._addButton.toggleMod('hidden', true, !isSomeInputHidden);
    },

    /**
     * Меняет data-err-path для audit-input
     * @private
     */
    _changeIndexErrorPath: function() {
        var indexError = 0;

        this._inputs.forEach(function(input) {
            var auditInputWrapper = input.findBlockOutside(this.__self.buildClass('audit-input')).domElem;

            if (input.val()) {
                auditInputWrapper.attr('data-err-path', indexError++);
            } else {
                auditInputWrapper.removeAttr('data-err-path');
            }
        }, this);
    },

    /**
     * Показывает/скрывает полные/пустые инпуты счетчика
     * @private
     */
    _toggleVisibilityInputsByValue: function() {
        this._inputs.forEach(function(input, index) {
            if (index) {
                input.toggleMod('hidden', true, !input.val());
            }
        }, this);
    },

    /**
     * Показывает инпуты счетчика, у которых индекс меньше maxLength,
     * скрытые очищает
     * @private
     */
    _showAndClearHiddenInputs: function(maxLength) {
        this._inputs.forEach(function(input, index) {
            if (index && maxLength <= index) {
                input.setMod('hidden', true);
                input.val('');
            }
        });
    },

    _initSubscriptions: function() {
        this._subscriptionManager.on(this._addButton, 'click', this._onAdd, this);
    },

    _onInputFocusBlur: function(e) {
        this._isSomeInputFocused = e.type === 'focus';

        if (!this._isSomeInputFocused) {
            // При очищении/заполнении инпута, пересчитывается индекс ошибки.
            // Тк с сервера приходит path без индекса, а просто массив
            this._changeIndexErrorPath();
        }
    },

    _onInputChange: function(e, data) {
        if (this.hasMod('cpm-group-type', 'cpm-video') &&
            !u.consts('rights').cpmVideoSeveralPixelsEnabled ||
            !this.hasMod('cpm-group-type', 'cpm-banner') &&
            !this.isFrontpageOrDeals) {
            return;
        }

        // При изменении счетчиков через массовые действия
        if (!this._isSomeInputFocused) {
            this._toggleVisibilityInputsByValue();
            this._updateVisibilityButton();

            // При очищении/заполнении инпута через массовые действия, пересчитывается индекс ошибки.
            // Тк с сервера приходит path без индекса, а просто массив
            this._changeIndexErrorPath();
        }
    },

    destruct: function() {
        this._subscriptionManager.dispose();
        this._subscriptionManager.destruct();

        this.__base.apply(this, arguments);
    }

}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent('focus blur', 'input', function(e) {
                this._onInputFocusBlur(e);
            })
            .liveInitOnBlockInsideEvent('change', 'input', function(e, data) {
                this._onInputChange(e, data);
            });

        return false;
    }

});
