block('b-edit-banner2').elem('body')(

    mix()([
        {
            block: 'b-edit-banner2',
            elem: 'body-row'
        },
        {
            block: 'b-edit-banner2',
            elem: 'row'
        },
        {
            block: 'b-layout-form',
            elem: 'row'
        }
    ]),

    content()(function() {
        var body = u.preview.skipSharpSign(this.banner.body),
            bodyLimit = +u.consts('MAX_BODY_LENGTH'),
            bodyLengthCounter = 0,
            labelContent;

        if (this.group.adgroup_type === 'mobile_content') {
            bodyLimit = u.consts('MAX_BODY_LENGTH_MOBILE');
            bodyLengthCounter = bodyLimit - body.length;
        } else {
            bodyLengthCounter = u.preview.strCounterWithoutNarrow(
                body,
                bodyLimit,
                u.consts('NARROW_SYMBOLS')
            );
        }

        labelContent = [
            iget2('b-edit-banner2', 'tekst-obyavleniya', 'Текст объявления'),
            {
                block: 'b-edit-banner2',
                elem: 'required'
            }
        ];

        return [
            {
                elem: 'label',
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'label'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: u.consts('rights').ajaxAdGroupsMultiSave ?
                    labelContent :
                    {
                        block: 'b-model-form-error',
                        mix: [{
                            block: 'b-model-form-error',
                            elem: 'label'
                        }],
                        modelParams: this.dmParams || this.modelParams,
                        field: 'body',
                        errors: this.errors.body,
                        content: labelContent
                    }
            },
            {
                elem: 'control',
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'control'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: [
                    u.consts('rights').ajaxAdGroupsMultiSave ?
                        {
                            block: 'b-error-pretty-message',
                            js: true,
                            mods: { theme: 'classic' },
                            mix: { block: 'b-edit-banner2', elem: 'pretty-errors-message' }
                        } :
                        {
                            block: 'b-model-form-error',
                            mix: [
                                {
                                    block: 'b-model-form-error',
                                    elem: 'control'
                                },
                                {
                                    block: 'b-edit-banner2',
                                    elem: 'wrap'
                                }
                            ],
                            errors: this.errors.body,
                            modelParams: this.dmParams || this.modelParams,
                            field: 'body'
                        },
                    {
                        block: 'b-edit-banner2',
                        elem: 'wrap',
                        content: [
                            {
                                block: 'input',
                                mods: { type: 'textarea' },
                                mix: [
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'model-field',
                                        js: { name: 'body', type: 'input' }
                                    },
                                    u.consts('rights').ajaxAdGroupsMultiSave ?
                                        {
                                            block: 'b-errors-presenter2',
                                            elem: 'cleaner',
                                            js: { block: 'input' }
                                        } :
                                        undefined
                                ],
                                limit: +u.consts('MAX_BODY_LENGTH'),
                                name: 'body',
                                value: this.banner.body,
                                content: {
                                    elem: 'control',
                                    attrs: {
                                        rows: 3,
                                        spellcheck: 'true'
                                    }
                                }
                            },
                            {
                                elem: 'body-length-counter',
                                mix: [{
                                    block: 'b-edit-banner2',
                                    elem: 'input-counter'
                                }],
                                elemMods: { 'under-zero': bodyLengthCounter >= 0 ? undefined : 'yes' },
                                content: bodyLengthCounter
                            }
                        ]
                    }
                ]
            }
        ];
    })
);
