block('b-edit-banner2').elem('content-promotion-description')(

    mix()([
        {
            block: 'b-edit-banner2',
            elem: 'row'
        },
        {
            block: 'b-layout-form',
            elem: 'row'
        }
    ]),

    content()(function() {
        var description = u.preview.skipSharpSign(this.banner.body),
            descriptionLimit = +u.consts('MAX_BODY_LENGTH_CONTENT_PROMOTION'),
            descriptionLengthCounter = u.preview.strCounterWithoutNarrow(
                description,
                descriptionLimit,
                u.consts('NARROW_SYMBOLS')
            ),
            labelContent = [
                iget2('b-edit-banner2', 'content-promotion-description-label', 'Описание'),
                {
                    block: 'b-edit-banner2',
                    elem: 'required'
                }
            ];

        return [
            {
                elem: 'label',
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'label'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: labelContent
            },
            {
                elem: 'control',
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'control'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: [
                    {
                        block: 'b-error-pretty-message',
                        js: true,
                        mods: { theme: 'classic' },
                        mix: {
                            block: 'b-edit-banner2',
                            elem: 'pretty-errors-message',
                            elemMods: { position: 'description' }
                        }
                    },
                    {
                        block: 'b-edit-banner2',
                        elem: 'wrap',
                        content: [
                            {
                                block: 'input',
                                mods: {
                                    size: 's',
                                    theme: 'normal',
                                    type: 'textarea'
                                },
                                js: true,
                                mix: [
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'model-field',
                                        js: {
                                            name: 'description',
                                            type: 'input'
                                        }
                                    }
                                ],
                                name: 'description',
                                limit: descriptionLimit,
                                placeholder: iget2('b-edit-banner2', 'add-content-description', 'Введите описание'),
                                content: { elem: 'control' },
                                value: this.banner.description || ''
                            },
                            {
                                elem: 'description-length-counter',
                                mix: [{
                                    block: 'b-edit-banner2',
                                    elem: 'input-counter'
                                }],
                                content: descriptionLengthCounter
                            }
                        ]
                    }
                ]
            }
        ];
    })
);
