block('b-edit-banner2').elem('content-promotion-title')(

    mix()([
        {
            block: 'b-edit-banner2',
            elem: 'row'
        },
        {
            block: 'b-layout-form',
            elem: 'row'
        }
    ]),

    content()(function() {
        var title = u.preview.skipSharpSign(this.banner.title),
            titleLimit = +u.consts('MAX_TITLE_LENGTH_CONTENT_PROMOTION'),
            labelContent,
            titleLengthCounter = u.preview.strCounterWithoutNarrow(
                title,
                titleLimit,
                ''
            );

        labelContent = [
            iget2('b-edit-banner2', 'content-promotion-title-label', 'Заголовок'),
            {
                block: 'b-edit-banner2',
                elem: 'required'
            }
        ];

        return [
            {
                elem: 'label',
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'label'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: labelContent
            },
            {
                elem: 'control',
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'control'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: [
                    {
                        block: 'b-error-pretty-message',
                        js: true,
                        mods: { theme: 'classic' },
                        mix: {
                            block: 'b-edit-banner2',
                            elem: 'pretty-errors-message',
                            elemMods: { position: 'title' }
                        }
                    },
                    {
                        block: 'b-edit-banner2',
                        elem: 'wrap',
                        content: [
                            {
                                block: 'input',
                                mods: {
                                    size: 's',
                                    theme: 'normal'
                                },
                                mix: [
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'model-field',
                                        js: {
                                            name: 'title',
                                            type: 'input'
                                        }
                                    }
                                ],
                                name: 'title',
                                limit: titleLimit,
                                placeholder: iget2('b-edit-banner2', 'add-content-title', 'Введите заголовок'),
                                content: { elem: 'control' },
                                value: this.banner.title || ''
                            },
                            {
                                elem: 'title-length-counter',
                                mix: [{
                                    block: 'b-edit-banner2',
                                    elem: 'input-counter'
                                }],
                                content: titleLengthCounter
                            }
                        ]
                    }
                ]
            }
        ];
    })
);
