block('b-edit-banner2').elem('header')(

    mix()([
        {
            block: 'b-edit-banner2',
            elem: 'row'
        },
        {
            block: 'b-layout-form',
            elem: 'row'
        },
        {
            block: 'b-edit-banner2',
            elem: 'header'
        }
    ]),

    content()(function() {
        var isCanBeCleared = this.group.adgroup_type !== 'mcbanner' && !u.campaign.isCpm(this.group.adgroup_type) &&
                (this.banner.isNewBanner || this.banner.ad_type !== 'image_ad' && this.banner.ad_type !== 'cpc_video');

        return [
            {
                elem: 'label',
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'label'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: {
                    elem: 'label-text',
                    attrs: { id: 'Banner-' + this.group.modelId + '-' + this.banner.modelId },
                    content: this.ctx.entityTitle || iget2('b-edit-banner2', 'obyavlenie', 'Объявление')
                }
            },
            {
                elem: 'control',
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'control'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: [
                    !!+this.banner.bid && {
                        elem: 'num',
                        content: '№ M-' + this.banner.bid
                    },
                    this.ctx.withMobile && (this.banner.isNewBanner || this.banner.banner_type === 'mobile') && {
                        block: 'b-edit-banner2',
                        elem: 'mobile',
                        elemMods: { 'for-new-banner': this.banner.isNewBanner ? 'yes' : '' }
                    },
                    //неразрывный пробел нужен, чтобы в ячейке всегда было содержимое, это позволяет actions справа не приехать на место ячейки
                    '&nbsp;'
                ]
            },
            {
                elem: 'info',
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'info'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: [
                    this.ctx.hasHeaderActions && {
                        elem: 'actions',
                        content: [
                            this.banner.hasCopyFromPrev && {
                                block: 'link',
                                mix: [
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'copy-from-prev'
                                    },
                                    this.mediaType == 'text' && {
                                        block: 'b-metrika',
                                        js: { goal: 'PREVIOUS_TEXT' }
                                    }
                                ],
                                mods: { pseudo: 'yes' },
                                content: this.bannerIndex == 0 ?
                                    iget2('b-edit-banner2', 'skopirovat-obyavlenie-iz-predydushchey', 'скопировать объявление из предыдущей группы') :
                                    iget2('b-edit-banner2', 'skopirovat-iz-predydushchego-obyavleniya', 'скопировать из предыдущего объявления')
                            },
                            // для ГО на поиске никогда не показываем кнопку
                            // для видео так же

                            isCanBeCleared && {
                                block: 'link',
                                mix: {
                                    block: 'b-edit-banner2',
                                    elem: 'clear-text'
                                },
                                mods: { pseudo: 'yes' },
                                content: iget2('b-edit-banner2', 'ochistit-obyavlenie', 'очистить объявление')
                            }
                        ]
                    },
                    this.canDelete && {
                        block: 'link',
                        mods: { pseudo: 'yes' },
                        mix: {
                            block: 'b-edit-banner2',
                            elem: 'delete-btn'
                        },
                        content: iget2('b-edit-banner2', 'otmenit-dobavlenie', 'отменить добавление')
                    }
                ]
            }
        ];
    })
);
