block('b-edit-banner2').elem('href')(

    mix()([
        {
            block: 'b-edit-banner2',
            elem: 'row'
        },
        {
            block: 'b-layout-form',
            elem: 'row'
        }
    ]),

    content()(function() {
        var ctx = this.ctx,
            modelParams = ctx.modelParams,
            banner = ctx.banner,
            optional = ctx.optional,
            labelContent = [
                {
                    elem: 'site-href',
                    content: iget2('b-edit-banner2', 'ssylka-na-sayt', 'Ссылка на сайт')
                },
                // бекенд не может получить домен из ссылки на сайт О_о
                {
                    elem: 'site-domain',
                    content: iget2('b-edit-banner2', 'domain-na-sayt', 'Домен')
                },
                {
                    block: 'b-edit-banner2',
                    elem: 'required',
                    mix: {
                        block: 'b-edit-banner2',
                        elem: 'href-required',
                        elemMods: { hidden: (banner.has_vcard || optional) ? 'yes' : '' }
                    }
                }
            ],
            promoCodeDomains = ctx.promoCodeDomains;

        return [
            {
                elem: 'label',
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'label'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: u.consts('rights').ajaxAdGroupsMultiSave ?
                    labelContent :
                    {
                        block: 'b-model-form-error',
                        mix: [{
                            block: 'b-model-form-error',
                            elem: 'label'
                        }],
                        modelParams: {
                            name: 'm-banner-href',
                            id: modelParams.id,
                            parentPath: modelParams.parentName + ':' + modelParams.parentId + '.' +
                                modelParams.name + ':' + modelParams.id
                        },
                        field: 'href',
                        errors: ctx.errors,
                        content: labelContent

                    }
            },
            {
                elem: 'control',
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'control'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: [
                    u.consts('rights').ajaxAdGroupsMultiSave ?
                        {
                            block: 'b-error-pretty-message',
                            js: true,
                            mods: { theme: 'classic' },
                            mix: {
                                block: 'b-edit-banner2',
                                elem: 'pretty-errors-message',
                                elemMods: { position: 'href' }
                            }
                        } :
                        {
                            block: 'b-model-form-error',
                            mix: [
                                {
                                    block: 'b-model-form-error',
                                    elem: 'control'
                                },
                                {
                                    block: 'b-edit-banner2',
                                    elem: 'href-error'
                                }
                            ],
                            modelParams: {
                                name: 'm-banner-href',
                                id: modelParams.id,
                                parentPath: modelParams.parentName + ':' + modelParams.parentId + '.' +
                                    modelParams.name + ':' + modelParams.id
                            },
                            field: 'href',
                            errors: ctx.errors
                        },
                    {
                        block: 'b-banner-href',
                        mods: {
                            'can-edit-domain': ctx.canEditDomain ? 'yes' : ''
                        },
                        mix: [
                            { block: 'b-edit-banner2', elem: 'href-control' },
                            u.consts('rights').ajaxAdGroupsMultiSave ?
                                {
                                    block: 'b-errors-presenter2',
                                    elem: 'cleaner',
                                    js: { block: 'b-banner-href' }
                                } :
                                undefined
                        ],
                        banner: banner,
                        modelParams: modelParams,
                        urlLengthLimit: ctx.urlLengthLimit,
                        canEditDomain: ctx.canEditDomain,
                        hrefReadOnly: ctx.hrefReadOnly,
                        protocolReadOnly: ctx.protocolReadOnly
                    },
                    promoCodeDomains && promoCodeDomains.length > 0 && {
                        elem: 'promo-code-warning',
                        elemMods: {
                            hidden: 'yes'
                        },
                        content: {
                            block: 'icon-text',
                            mods: {
                                theme: 'alert',
                                size: 'xs'
                            },
                            text: iget2(
                                'b-edit-banner2',
                                'promo-code-warning',
                                'Домен объявления отличается от домена, на который активирован промокод. При смене или добавлении домена промокод будет аннулирован'
                            )
                        }
                    },
                    (this.group.adgroup_type === 'text' || this.group.adgroup_type === 'base') && {
                        block: 'b-edit-banner2',
                        elem: 'display-link',
                        elemMods: {
                            visible: banner.href ? 'yes' : 'no'
                        },
                        mix: [{
                            block: 'b-edit-banner2',
                            elem: 'model-field',
                            js: {
                                name: 'has_href_only',
                                type: 'mod',
                                block: 'b-edit-banner2',
                                elem: 'display-link',
                                modName: 'visible'
                            }
                        }],
                        attrs: { 'data-err-path': 'display_href' }
                    }
                ]
            },
            {
                elem: 'info',
                mix: [
                    {
                        block: 'b-edit-group',
                        elem: 'info',
                        elemMods: { href: 'yes' }
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'control'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: false
            }
        ];
    })
);
