/**
 * @property {Object} this.ctx
 * @property {String} this.ctx.errorPath путь для отображения ошибок
 * @property {Object} this.ctx.banner баннер, которому принадлежит ссылка
 * @property {Object} this.ctx.canEditDomain можно ли редактировать домен
 * @property {Object} this.ctx.modelParams параметры модели баннера
 * @property {Number} this.ctx.urlLengthLimit ограничение длины ссылки
 */
block('b-edit-banner2').elem('href2')(

    mix()([
        {
            block: 'b-edit-banner2',
            elem: 'row'
        },
        {
            block: 'b-layout-form',
            elem: 'row'
        }
    ]),

    content()(function() {
        var errorPath = this.ctx.errorPath,
            banner = this.ctx.banner;

        return [
            {
                elem: 'label',
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'label'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    },
                    {
                        block: 'b-error-label',
                        js: { path: errorPath }
                    }
                ],
                content: [
                    iget2('b-edit-banner2', 'ssylka-na-sayt', 'Ссылка на сайт'),
                    {
                        block: 'b-edit-banner2',
                        elem: 'required',
                        mix: {
                            block: 'b-edit-banner2',
                            elem: 'href-required',
                            elemMods: { hidden: banner.has_vcard ? 'yes' : '' }
                        }
                    }
                ]
            },
            {
                elem: 'control',
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'control'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: [
                    {
                        block: 'b-error-message',
                        js: { path: errorPath }
                    },
                    {
                        block: 'b-banner-href',
                        mods: {
                            'can-edit-domain': this.ctx.canEditDomain ? 'yes' : ''
                        },
                        mix: [{
                            block: 'b-edit-banner2',
                            elem: 'href-control'
                        }],
                        banner: banner,
                        modelParams: this.ctx.modelParams,
                        urlLengthLimit: this.ctx.urlLengthLimit,
                        canEditDomain: this.ctx.canEditDomain
                    }
                ]
            },
            {
                elem: 'info',
                mix: [
                    {
                        block: 'b-edit-group',
                        elem: 'info',
                        elemMods: { href: 'yes' }
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'control'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: false
            }
        ];
    })
);
