block('b-edit-banner2').elem('image-ad')(

    mix()([
        {
            block: 'b-edit-banner2',
            elem: 'body-row'
        },
        {
            block: 'b-edit-banner2',
            elem: 'row'
        },
        {
            block: 'b-layout-form',
            elem: 'row'
        }
    ]),

    content()(function() {
        var campaign = this.campaign,
            banner = this.banner,
            currentCreative = banner.creative,
            currentImageAd = banner.image_ad,
            size = this.ctx.size,
            labelContent,
            checkBannerFormat = function(picture) {
                // если задан размер баннера, показыаем только картинки этого размера
                if (size) {
                    return size.width == picture.width && size.height == picture.height;
                } else {
                    // в ранее загруженных выводятся только баннеры с соответсвующим форматом
                    // и исключается изображение текущего баннера
                    return (banner.isNewBanner ||
                        (currentImageAd &&
                            picture.width == currentImageAd.width &&
                            picture.height == currentImageAd.height
                        )
                    );
                }
            };

        labelContent = [
            iget2('b-edit-banner2', 'kreativ-107', 'Креатив'),
            {
                block: 'b-edit-banner2',
                elem: 'required'
            }
        ];

        return [
            {
                elem: 'label',
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'label'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: u.consts('rights').ajaxAdGroupsMultiSave ?
                    labelContent :
                    {
                        block: 'b-model-form-error',
                        mix: [{
                            block: 'b-model-form-error',
                            elem: 'label'
                        }],
                        modelParams: this.dmParams,
                        field: 'image_ad creative',
                        errors: this.errors.image_ad,
                        content: labelContent
                    }
            },
            {
                elem: 'control',
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'control'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: [
                    u.consts('rights').ajaxAdGroupsMultiSave ?
                        {
                            block: 'b-error-pretty-message',
                            js: true,
                            mods: { theme: 'classic' },
                            mix: { block: 'b-edit-banner2', elem: 'pretty-errors-message' }
                        } :
                        {
                            block: 'b-model-form-error',
                            mix: [
                                {
                                    block: 'b-model-form-error',
                                    elem: 'control'
                                },
                                {
                                    block: 'b-edit-banner2',
                                    elem: 'wrap'
                                }
                            ],
                            errors: this.errors.image_ad,
                            modelParams: this.dmParams,
                            field: 'image_ad creative'
                        },
                    this.ctx.isReadOnly ?
                        (currentImageAd || currentCreative || {}).name :
                        {
                            block: 'b-image-add-loader',
                            mix: [{ block: 'b-edit-banner2', elem: 'image-ad-loader' }].concat(
                                u.consts('rights').ajaxAdGroupsMultiSave ?
                                    {
                                        block: 'b-errors-presenter2',
                                        elem: 'cleaner',
                                        js: { block: 'b-image-add-loader', event: 'reset change:creatives' }
                                    } :
                                    []
                            ),
                            mediaType: campaign.mediaType,
                            bannerId: banner.bid,
                            clientId: campaign.ClientID,

                            image: currentImageAd,
                            creative: currentCreative,

                            isNewBanner: banner.isNewBanner,
                            cpmGroupType: this.group.cpmGroupType,

                            askGroupLink: true,
                            availableBannerCount: this.availableBannerCount,
                            dmParams: this.dmParams,
                            gallery: (campaign.pictures || []).reduce(function(result, picture) {
                                if (checkBannerFormat(picture)) {
                                    result.push(u._.extend({}, picture, {
                                        url: u.getImageUrl({
                                            namespace: 'direct-picture',
                                            mdsGroupId: picture.group_id,
                                            hash: picture.hash
                                        })
                                    }));
                                }

                                return result;
                            }, [])
                        }
                ]
            }
        ];
    })
);
