/**
 * @property {Object} this.ctx
 * @property {Object} this.ctx.banner баннер, которому принадлежит изображение
 * @property {Object} this.ctx.campaign кампания, которой принадлежит баннер
 * @property {{ width: Number, height: Number }} [this.ctx.size] размер изображения
 * @property {Number} this.ctx.availableBannerCount лимит объявлений в группе
 * @property {String} this.ctx.errorPath путь для отображения ошибок
 */
block('b-edit-banner2').elem('image-ad2')(

    mix()([
        {
            block: 'b-edit-banner2',
            elem: 'body-row'
        },
        {
            block: 'b-edit-banner2',
            elem: 'row'
        },
        {
            block: 'b-layout-form',
            elem: 'row'
        }
    ]),

    content()(function() {
        var campaign = this.ctx.campaign,
            banner = this.ctx.banner,
            currentCreative = banner.creative,
            currentImageAd = banner.image_ad,
            size = this.ctx.size,
            errorPath = this.ctx.errorPath,
            checkBannerFormat = function(picture) {
                // если задан размер баннера, показыаем только картинки этого размера
                if (size) {
                    return size.width == picture.width && size.height == picture.height;
                } else {
                    // в ранее загруженных выводятся только баннеры с соответсвующим форматом
                    // и исключается изображение текущего баннера
                    return (banner.isNewBanner ||
                        (currentImageAd &&
                            picture.width == currentImageAd.width &&
                            picture.height == currentImageAd.height
                        )
                    );
                }
            };

        return [
            {
                elem: 'label',
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'label'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    },
                    {
                        block: 'b-error-label',
                        js: { path: errorPath }
                    }
                ],
                content: [
                    iget2('b-edit-banner2', 'kreativ-107', 'Креатив'),
                    {
                        block: 'b-edit-banner2',
                        elem: 'required'
                    }
                ]
            },
            {
                elem: 'control',
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'control'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: [
                    {
                        block: 'b-error-message',
                        js: { path: errorPath }
                    },
                    this.ctx.isReadOnly ?
                        (currentImageAd || currentCreative || {}).name :
                        {
                            block: 'b-image-add-loader',
                            mix: {
                                block: 'b-edit-banner2',
                                elem: 'image-ad-loader'
                            },
                            mediaType: campaign.mediaType,
                            bannerId: banner.bid,
                            clientId: campaign.ClientID,

                            image: currentImageAd,
                            creative: currentCreative,

                            isNewBanner: banner.isNewBanner,
                            cpmGroupType: this.group.cpmGroupType,

                            askGroupLink: true,
                            availableBannerCount: this.availableBannerCount,
                            dmParams: this.dmParams,
                            gallery: (campaign.pictures || []).reduce(function(result, picture) {
                                if (checkBannerFormat(picture)) {
                                    result.push(u._.extend({}, picture, {
                                        url: u.getImageUrl({
                                            namespace: 'direct-picture',
                                            mdsGroupId: picture.group_id,
                                            hash: picture.hash
                                        })
                                    }));
                                }

                                return result;
                            }, [])
                        }
                ]
            }
        ];
    })
);
