block('b-edit-banner2').elem('measurers')(

    match(function() { return !!this.ctx.availableMeasurers; }).def()(function() {
        return applyNext({
            'elemMods.available': 'yes'
        });
    }),

    mix()([
        { block: 'b-edit-banner2', elem: 'row' },
        { block: 'b-layout-form', elem: 'row' }
    ]),

    content()(function() {
        return [
            {
                elem: 'label',
                mix: [
                    { block: 'b-layout-form', elem: 'label' },
                    { block: 'b-layout-form', elem: 'cell' }
                ],
                content: [
                    iget2('b-edit-banner2', 'measurers', 'Внешние измерители'),
                    '&nbsp;',
                    {
                        block: 'b-help-link',
                        mix: [
                            {
                                block: 'b-hintable-popup',
                                js: {
                                    hint: iget2(
                                        'b-edit-banner2',
                                        'measurers-hint-description',
                                        'Подключение внешних измерителей позволяет осуществлять мониторинг и измерение показов объявлений на внешних аналитических площадках'
                                    ),
                                    directions: ['right', 'bottom', 'top'],
                                    mixPopup: { block: 'b-edit-banner2', elem: 'measurers-hint' }
                                }
                            }
                        ]
                    }
                ]
            },
            {
                elem: 'control',
                mix: [
                    { block: 'b-layout-form', elem: 'control' },
                    { block: 'b-layout-form', elem: 'cell' }
                ],
                content: [
                    {
                        block: 'b-error-pretty-message',
                        js: true,
                        mods: { theme: 'classic' },
                        mix: {
                            block: 'b-edit-banner2',
                            elem: 'pretty-errors-message'
                        }
                    },
                    {
                        elem: 'measurers-table',
                        mix: { block: 'b-style-table', mods: { theme: 'gray-list' } },
                        content: apply('measurers-list', { ctx: u._.pick(this.ctx, ['banner', 'availableMeasurers']) })
                    }
                ]
            }
        ];
    }),

    mode('measurers-list')(function() {
        var banner = this.ctx.banner,
            availableMeasurers = this.ctx.availableMeasurers;

        return u.measurers.getMeasurerSystems().map(function(measurer) {
            var triggerName = u.measurers.getTriggerName(measurer),
                isEnabled = u.measurers.isEnabled(banner, measurer),
                hasIntegration = u.measurers.hasIntegration(measurer),
                withoutParams = u.measurers.withoutParams(measurer),
                isHidden = !availableMeasurers || !availableMeasurers[measurer],
                measurerName = u.measurers.getMeasurerSystemName(measurer);

            return {
                elem: 'measurers-table-row',
                elemMods: { measurer: u.beminize(measurer), hidden: isHidden ? 'yes' : '' },
                mix: [
                    { block: 'b-style-table', elem: 'row' },
                    hasIntegration ?
                        ({
                            block: 'b-edit-banner2',
                            elem: 'measurer-integrable',
                            js: { measurer: measurer }
                        }) :
                        false
                ],
                content: [
                    {
                        elem: 'measurers-table-cell',
                        mix: { block: 'b-style-table', elem: 'cell' },
                        content: [
                            {
                                block: 'checkbox',
                                mods: {
                                    checked: isEnabled ? 'yes' : '',
                                    lines: 'one',
                                    disabled: hasIntegration ? 'yes' : ''
                                },
                                mix: {
                                    block: 'b-edit-banner2',
                                    elem: 'model-field',
                                    js: { name: triggerName, type: 'checkbox' }
                                },
                                text: measurerName
                            },
                            hasIntegration ?
                                ({
                                    elem: 'measurer-integrable-link-to-authorize',
                                    content: iget2(
                                        'b-edit-banner2',
                                        'login-to-change-measurer',
                                        'Для изменения измерителя авторизуйтесь {link}',
                                        {
                                            link: function(text) {
                                                return {
                                                    block: 'link',
                                                    mods: { theme: 'direct' },
                                                    url: u.formatUrl({
                                                        path: '/dna/integrations',
                                                        query: { ulogin: u.consts('ulogin') }
                                                    }),
                                                    target: '_blank',
                                                    text: text
                                                };
                                            }(
                                                iget2(
                                                    'b-edit-banner2',
                                                    'in-panel',
                                                    'в панели {name}',
                                                    { name: measurerName }
                                                )
                                            )
                                        }
                                    )
                                }) :
                                ''
                        ]
                    },
                    {
                        elem: 'measurers-table-cell',
                        elemMods: { content: 'params' },
                        mix: { block: 'b-style-table', elem: 'cell' },
                        content: [
                            {
                                block: 'b-edit-banner2',
                                elem: 'measurer-field',
                                elemMods: { visible: isEnabled ? 'yes' : '' },
                                mix: {
                                    block: 'b-edit-banner2',
                                    elem: 'model-field',
                                    js: {
                                        name: triggerName,
                                        type: 'mod',
                                        modName: 'visible',
                                        block: 'b-edit-banner2',
                                        elem: 'measurer-field'
                                    }
                                },
                                content: (withoutParams ?
                                    ([
                                        hasIntegration && { elem: 'measurer-integrable-loader' },
                                        {
                                            elem: 'measurer-params-will-be',
                                            content: iget2(
                                                'b-edit-banner2',
                                                'params-will-be-filled-automaticly',
                                                'Параметры будут заполнены автоматически'
                                            )
                                        }
                                    ]) :
                                    []).concat({
                                        block: 'input',
                                        mods: { theme: 'normal', type: 'textarea', disabled: !isEnabled ? 'yes' : '', },
                                        mix: [
                                            {
                                                block: 'b-edit-banner2',
                                                elem: 'model-field',
                                                js: { name: u.measurers.getParamsName(measurer), type: 'input' },
                                            },
                                            { block: 'b-errors-presenter2', elem: 'cleaner', js: { block: 'input' } },
                                            {
                                                block: 'b-edit-banner2',
                                                elem: 'measurer-params-input',
                                                elemMods: { hidden: withoutParams ? 'yes' : '' }
                                            }
                                        ],
                                        value: u.measurers.getParams(banner, measurer),
                                        content: { elem: 'control', attrs: { rows: 1 } }
                                    })
                            }
                        ]
                    }
                ]
            };
        });
    }),

    elem('measurers-table').tag()('table'),

    elem('measurers-table-row').tag()('tr'),

    elem('measurers-table-cell').tag()('td')

);
