/**
 * Заголовок баннера, используется type_mobile-content
 */
block('b-edit-banner2').elem('mobile-content-title')(

    mix()([
        {
            block: 'b-edit-banner2',
            elem: 'row'
        },
        {
            block: 'b-layout-form',
            elem: 'row'
        }
    ]),

    content()(function() {
        var titleLimit = u.consts('NEW_MAX_TITLE_LENGTH_MOBILE'),
            titleLength = u.preview.skipSharpSign(this.banner.title || '').length,
            titleLengthCounter = titleLimit - titleLength;

        return [
            {
                elem: 'label',
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'label'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: {
                    block: 'b-model-form-error',
                    mix: [{
                        block: 'b-model-form-error',
                        elem: 'label'
                    }],
                    modelParams: this.dmParams,
                    field: 'title',
                    errors: this.errors.title,
                    content: [
                        iget2('b-edit-banner2', 'zagolovok', 'Заголовок'),

                        {
                            block: 'b-edit-banner2',
                            elem: 'required'
                        },
                        {
                            block: 'b-help-link',
                            mods: { type: 'modal' },
                            mix: [{
                                block: 'b-edit-banner2',
                                elem: 'help-icon'
                            }],
                            stretched: true,
                            url: u.getHelpUrl('make-correct-ad'),
                            title: iget2('b-edit-banner2', 'kak-sostavit-horoshee-obyavlenie', 'Как составить хорошее объявление?')
                        }
                    ]
                }
            },
            {
                elem: 'control',
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'control'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: [
                    {
                        block: 'b-model-form-error',
                        mix: [
                            {
                                block: 'b-model-form-error',
                                elem: 'control'
                            },
                            {
                                block: 'b-edit-banner2',
                                elem: 'wrap'
                            }
                        ],
                        modelParams: this.dmParams,
                        field: 'title',
                        errors: this.errors.title
                    },
                    {
                        block: 'b-edit-banner2',
                        elem: 'wrap',
                        content: [
                            {
                                block: 'input',
                                mix: [{
                                    block: 'b-edit-banner2',
                                    elem: 'model-field',
                                    js: {
                                        name: 'title',
                                        type: 'input'
                                    }
                                }],
                                name: 'title',
                                limit: titleLimit,
                                value: this.banner.title,
                                content: {
                                    elem: 'control',
                                    attrs: {
                                        spellcheck: true,
                                        type: 'text'
                                    }
                                }
                            },
                            {
                                elem: 'title-length-counter',
                                mix: [{
                                    block: 'b-edit-banner2',
                                    elem: 'input-counter'
                                }],
                                elemMods: { 'under-zero': titleLengthCounter >= 0 ? undefined : 'yes' },
                                content: titleLengthCounter
                            }
                        ]
                    }
                ]
            }
        ];
    })
);
