block('b-edit-banner2').elem('preview').elemMod('type', 'dynamic').replace()(function() {

    var group = this.group,
        banner = this.banner,
        campaign = this.campaign,
        groupId = group.modelId,
        banners = [u._.pick(banner, ['image', 'creative', 'banner_type', 'sitelinks'])],
        campMediaType = campaign.mediaType;

    return {
        block: 'b-banner-viewer',
        mix: {
            block: 'b-edit-banner2',
            elem: 'banner-viewer'
        },
        js: {
            modelBannerParams: this.modelParams,
            modelCampaignParams: {
                name: 'm-campaign',
                id: campaign.cid
            }
        },
        content: [
            {
                block: 'b-banner-preview-filter2',
                mix: [{
                    block: 'b-banner-viewer',
                    elem: 'filter'
                }],
                tabList: u['b-banner-preview-filter2'].getTabsList({
                    strategySearchName: campaign.strategy.search.name,
                    dontShowYacontext: campaign.dontShowYacontext,
                    campMediaType: campMediaType,
                    banners: banners
                }),
                isPartnerAllFormatsEnabled: u['b-banner-preview-filter2'].isPartnerAllFormatsEnabled({
                    campMediaType: campMediaType,
                    banners: banners
                })
            },
            {
                elem: 'banner',
                content: [
                    {
                        block: 'b-banner-preview2',
                        mods: {
                            type: 'dynamic',
                            view: 'edit'
                        },
                        data: u['b-banner-preview2_type_dynamic'].fromServer({
                            banner: banner,
                            group: group,
                            campaign: campaign
                        }),
                        modelsParams: {
                            dmsIds: {
                                bannerId: banner.modelId,
                                groupId: groupId
                            }
                        }
                    },
                    {
                        block: 'b-banner-preview2-warnings',
                        mods: { 'auto-check': 'yes' },
                        mix: { block: 'b-edit-banner2', elem: 'warnings' },
                        modelParams: this.modelParams
                    }
                ]
            }
        ]
    };
});
