block('b-edit-banner2').elem('preview').elemMod('type', 'mobile-content').replace()(function() {

    var group = this.group,
        banner = this.banner,
        campaign = this.campaign,
        randPhrase = u['dm-base-group'].getRandomActivePhrase(group.phrases || []),
        banners = [u._.pick(banner, ['image', 'creative', 'banner_type', 'sitelinks'])],
        campMediaType = campaign.mediaType,
        tabList = u['b-banner-preview-filter2'].getTabsList({
            strategySearchName: campaign.strategy.search.name,
            dontShowYacontext: campaign.dontShowYacontext,
            campMediaType: campMediaType,
            banners: banners
        }),
        isPartnerAllFormatsEnabled = u['b-banner-preview-filter2'].isPartnerAllFormatsEnabled({
            campMediaType: campMediaType,
            banners: banners
        }),
        isBannerWithImageAd = (banner.ad_type === 'image_ad') ||
            (banner.creative && banner.creative.creative_id),
        view,
        blockNameByType = u['b-banner-preview2'].getNameByType(
            'mobile_content',
            isBannerWithImageAd ? 'base-image' : undefined
        );

    if (isBannerWithImageAd) {
        view = 'base-image'
    } else {
        view = u._.find(tabList, { type: 'search' }) ? 'mobile-content-search' : 'mobile-content-edit';
    }

    return {
        block: 'b-banner-viewer',
        mix: [{
            block: 'b-edit-banner2',
            elem: 'banner-viewer'
        }],
        mods: {
            'current-view': view
        },
        js: {
            modelBannerParams: this.dmParams,
            modelCampaignParams: {
                name: 'dm-mobile-content-campaign',
                id: campaign.cid
            }
        },
        content: [
            {
                elem: 'preview-filter',
                content: {
                    block: 'b-banner-preview-filter2',
                    mix: [{
                        block: 'b-banner-viewer',
                        elem: 'filter'
                    }],
                    tabList: tabList,
                    isPartnerAllFormatsEnabled: isPartnerAllFormatsEnabled
                }
            },
            {
                elem: 'banner',
                content: [
                    {
                        block: 'b-banner-preview2',
                        mods: {
                            type: 'mobile-content',
                            view: view
                        },
                        data: u[blockNameByType].fromServer({
                            banner: banner,
                            phrase: randPhrase,
                            mobileContent: group.mobile_content,
                            campaign: campaign,
                            group: group
                        }),
                        modelsParams: {
                            dmsIds: {
                                bannerId: banner.modelId,
                                groupId: group.modelId,
                                mobileContentId: group.groupId,
                                phraseId: (randPhrase || {}).modelId
                            }
                        }
                    },
                    {
                        block: 'b-banner-preview2-warnings',
                        mods: { 'auto-check': 'yes' },
                        mix: { block: 'b-edit-banner2', elem: 'warnings' },
                        modelParams: this.dmParams
                    }
                ]
            }
        ]
    };

});
