/**
 * Заголовок баннера, используется в type_text
 */
block('b-edit-banner2').elem('title-ext')(

    mix()([
        {
            block: 'b-edit-banner2',
            elem: 'row'
        },
        {
            block: 'b-layout-form',
            elem: 'row'
        }
    ]),

    content()(function() {
        var titleExt = u.preview.skipSharpSign(this.banner.title_extension),
            titleLimit = u.consts('MAX_TITLE_EXTENSION_LENGTH'),
            labelContent,
            titleLengthCounter = u.preview.strCounterWithoutNarrow(
                titleExt,
                titleLimit,
                u.consts('NARROW_SYMBOLS')
            );

        labelContent = [
            iget2('b-edit-banner2', 'zagolovok-2', 'Заголовок 2'),
            {
                block: 'b-help-link',
                mods: { type: 'modal' },
                mix: [{
                    block: 'b-edit-banner2',
                    elem: 'help-icon'
                }],
                stretched: true,
                url: u.getHelpUrl('title-2'),
                title: iget2('b-edit-banner2', 'kak-sostavit-horoshee-obyavlenie', 'Как составить хорошее объявление?')
            }
        ];

        return [
            {
                elem: 'label',
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'label'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: u.consts('rights').ajaxAdGroupsMultiSave ?
                    labelContent :
                    {
                        block: 'b-model-form-error',
                        mix: [{
                            block: 'b-model-form-error',
                            elem: 'label'
                        }],
                        modelParams: this.dmParams,
                        field: 'title_extension',
                        errors: this.errors.title_extension,
                        content: labelContent
                    }
            },
            {
                elem: 'control',
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'control'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: [
                    u.consts('rights').ajaxAdGroupsMultiSave ?
                        {
                            block: 'b-error-pretty-message',
                            js: true,
                            mods: { theme: 'classic' },
                            mix: { block: 'b-edit-banner2', elem: 'pretty-errors-message' }
                        } :
                        {
                            block: 'b-model-form-error',
                            mix: [
                                {
                                    block: 'b-model-form-error',
                                    elem: 'control'
                                },
                                {
                                    block: 'b-edit-banner2',
                                    elem: 'wrap'
                                }
                            ],
                            modelParams: this.dmParams,
                            field: 'title_extension',
                            errors: this.errors.title_extension
                        },
                    {
                        block: 'b-edit-banner2',
                        elem: 'wrap',
                        content: [
                            {
                                block: 'input',
                                mix: [
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'model-field',
                                        js: {
                                            name: 'title_extension',
                                            type: 'input'
                                        }
                                    },
                                    u.consts('rights').ajaxAdGroupsMultiSave ?
                                        {
                                            block: 'b-errors-presenter2',
                                            elem: 'cleaner',
                                            js: { block: 'input' }
                                        } :
                                        undefined
                                ],
                                name: 'title_extension',
                                limit: titleLimit,
                                value: this.banner.title_extension,
                                content: {
                                    elem: 'control',
                                    attrs: {
                                        spellcheck: true,
                                        type: 'text'
                                    }
                                }
                            },
                            {
                                elem: 'title-ext-length-counter',
                                mix: [{
                                    block: 'b-edit-banner2',
                                    elem: 'input-counter'
                                }],
                                content: titleLengthCounter
                            }
                        ]
                    }
                ]
            }
        ];
    })
);
