/**
 * Заголовок баннера, используется в type_text
 */
block('b-edit-banner2').elem('title')(

    mix()([
        {
            block: 'b-edit-banner2',
            elem: 'row'
        },
        {
            block: 'b-layout-form',
            elem: 'row'
        }
    ]),

    content()(function() {
        var title = u.preview.skipSharpSign(this.banner.title),
            titleLimit = +u.consts('NEW_MAX_TITLE_LENGTH'),
            labelContent,
            titleLengthCounter = u.preview.strCounterWithoutNarrow(
                title,
                titleLimit,
                ''
            );

        labelContent = [
            iget2('b-edit-banner2', 'zagolovok-1', 'Заголовок 1'),

            {
                block: 'b-edit-banner2',
                elem: 'required'
            },
            {
                block: 'b-help-link',
                mods: { type: 'modal' },
                mix: [{
                    block: 'b-edit-banner2',
                    elem: 'help-icon'
                }],
                stretched: true,
                url: u.getHelpUrl('make-correct-ad'),
                title: iget2('b-edit-banner2', 'kak-sostavit-horoshee-obyavlenie', 'Как составить хорошее объявление?')
            }
        ];

        return [
            {
                elem: 'label',
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'label'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: u.consts('rights').ajaxAdGroupsMultiSave ?
                    labelContent :
                    {
                        block: 'b-model-form-error',
                        mix: [{
                            block: 'b-model-form-error',
                            elem: 'label'
                        }],
                        modelParams: this.dmParams,
                        field: 'title',
                        errors: this.errors.title,
                        content: labelContent
                    }
            },
            {
                elem: 'control',
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'control'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: [
                    u.consts('rights').ajaxAdGroupsMultiSave ?
                        {
                            block: 'b-error-pretty-message',
                            js: true,
                            mods: { theme: 'classic' },
                            mix: {
                                block: 'b-edit-banner2',
                                elem: 'pretty-errors-message'
                            }
                        } :
                        {
                            block: 'b-model-form-error',
                            mix: [
                                {
                                    block: 'b-model-form-error',
                                    elem: 'control'
                                },
                                {
                                    block: 'b-edit-banner2',
                                    elem: 'wrap'
                                }
                            ],
                            modelParams: this.dmParams,
                            field: 'title',
                            errors: this.errors.title
                        },
                    {
                        block: 'b-edit-banner2',
                        elem: 'wrap',
                        content: [
                            {
                                block: 'input',
                                mix: [
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'model-field',
                                        js: {
                                            name: 'title',
                                            type: 'input'
                                        }
                                    },
                                    u.consts('rights').ajaxAdGroupsMultiSave ?
                                        {
                                            block: 'b-errors-presenter2',
                                            elem: 'cleaner',
                                            js: { block: 'input' }
                                        } :
                                        undefined
                                ],
                                name: 'title',
                                limit: titleLimit,
                                value: this.banner.title,
                                content: {
                                    elem: 'control',
                                    attrs: {
                                        spellcheck: 'true',
                                        type: 'text'
                                    }
                                }
                            },
                            {
                                elem: 'title-length-counter',
                                mix: [{
                                    block: 'b-edit-banner2',
                                    elem: 'input-counter'
                                }],
                                content: titleLengthCounter
                            }
                        ]
                    }
                ]
            }
        ];
    })
);
