BEM.DOM.decl({ block: 'b-edit-banner2', elem: 'turbo-geoproduct' }, {
    onSetMod: {
        js: function() {
            this._turboLandingsSelectorWrapperElem = this.elem('turbo-landings-control-wrapper');
            this._turboLandingsSelector = this.findBlockInside('turbo-landings-control', 'b-turbo-landings-selector');
            this._errorMessage = this.findBlockInside('turbo-geoproduct', 'b-error-pretty-message');

            this.model = this.getParent().model;

            this._subMan = BEM.create('i-subscription-manager');

            this._initSubscriptions();
        }
    },

    destruct: function() {
        this._subMan.dispose();
        this._subMan.destruct();

        this.__base.apply(this, arguments);
    },

    _initSubscriptions: function() {

        this._subMan.wrap(this.model)
            .on('turbolandingGeoproduct', 'change', function(e, data) {
                var value;

                if (data.hasOwnProperty('value')) {
                    value = data.value || {};

                    this._turboLandingsSelector.setValue(value);
                    this._errorMessage.clearErrors();
                }
            }, this);

        this._subMan.wrap(this._turboLandingsSelector).on('change', function(e, data) {
            if (data.id) {
                this.model.set('turbolandingGeoproduct', data);
            } else {
                this.model.clear('turbolandingGeoproduct');
            }

        }, this);
    }
});
