block('b-edit-banner2').elem('turbo-landings')(

    mix()([
        {
            block: 'b-edit-banner2',
            elem: 'row'
        },
        {
            block: 'b-layout-form',
            elem: 'row'
        }
    ]),

    js()(true),

    content()(function() {
        var hasTurbolanding = !!this.ctx.turbolanding,
            hrefParams = this.ctx.turbolanding_href_params,
            sitelinks = this.ctx.sitelinks,
            hasSiteLink = false,
            isNewGroup = this.ctx.isNewGroup,
            banner = this.banner;

        sitelinks && sitelinks.forEach(function(sitelink) {
            if (sitelink.turbolanding) {
                hasSiteLink = true;
            }
        });

        return [
            {
                elem: 'label',
                elemMods: {
                    'has-site': (banner.bid && banner.has_site_enum) ? banner.has_site_enum : 'yes'
                },
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'label'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    },
                    {
                        block: 'b-edit-banner2',
                        elem: 'turbo-landing-label'
                    },
                    {
                        block: 'b-edit-banner2',
                        elem: 'model-field',
                        js: {
                            name: 'has_site_enum',
                            type: 'mod',
                            modName: 'has-site',
                            block: 'b-edit-banner2',
                            elem: 'label'
                        }
                    }
                ],
                content: [
                    {
                        elem: 'desktop-turbo-title',
                        content: [
                            iget2('b-edit-banner2', 'turbolanding', 'Турбо&#8209;страница'),
                            {
                                block: 'icon',
                                mix: [
                                    { block: 'b-edit-banner2', elem: 'turbo-icon' }
                                ],
                                mods: {
                                    size: 's',
                                    type: 'turbo'
                                }
                            }
                        ]
                    },
                    {
                        elem: 'mobile-turbo-title',
                        content: [
                            iget2('b-edit-banner2', 'mobile-turbolanding', 'Мобильная Турбо&#8209;страница'),
                            {
                                block: 'icon',
                                mix: [
                                    { block: 'b-edit-banner2', elem: 'turbo-icon' }
                                ],
                                mods: {
                                    size: 's',
                                    type: 'turbo'
                                }
                            }
                        ]
                    },
                    {
                        block: 'b-edit-banner2',
                        elem: 'required'
                    }
                ]
            },
            {
                elem: 'control',
                attrs: { 'data-err-path': 'turbolanding' },
                mix: [
                    {
                        block: 'b-layout-form',
                        elem: 'control'
                    },
                    {
                        block: 'b-layout-form',
                        elem: 'cell'
                    }
                ],
                content: [
                    {
                        block: 'b-error-pretty-message',
                        js: true,
                        mods: { theme: 'classic' },
                        mix: [
                            {
                                block: 'b-edit-banner2',
                                elem: 'pretty-errors-message'
                            },
                            {
                                block: 'b-edit-banner2',
                                elem: 'model-field',
                                js: {
                                    name: 'has_site_enum',
                                    type: 'mod',
                                    modName: 'has-site',
                                    block: 'b-edit-banner2',
                                    elem: 'pretty-errors-message'
                                }
                            }
                        ]
                    },
                    {
                        block: 'b-edit-banner2',
                        elem: 'turbo-landings-control-wrapper',
                        content: [
                            {
                                block: 'b-edit-banner2',
                                elem: 'turbo-landings-control',
                                content: {
                                    block: 'b-turbo-landings-selector',
                                    mix: {
                                        block: 'b-edit-banner2',
                                        elem: 'model-field',
                                        js: {
                                            name: 'has_site_enum',
                                            type: 'mod',
                                            modName: 'has-site',
                                            block: 'b-turbo-landings-selector'
                                        }
                                    },
                                    mods: {
                                        disabled: 'yes',
                                        'has-site': (banner.bid && banner.has_site_enum) ? banner.has_site_enum : 'yes',
                                        'vcard-allowed': this.mods['vcard-allowed'],
                                        pretty: 'yes',
                                        fetching: false,
                                        warning: isNewGroup ? 'yes' : '' // Для новой группы отображаем текст, что необходимо ввести сайт
                                    },
                                    clientId: this.ctx.clientId,
                                    value: this.ctx.turbolanding
                                }
                            },
                            {
                                block: 'b-edit-banner2',
                                elem: 'tracking-variables-wrapper',
                                elemMods: {
                                    hidden: hasTurbolanding || hasSiteLink ? '' : 'yes'
                                },
                                content: [
                                    {
                                        block: 'b-href-params',
                                        mods: {
                                            active: hrefParams ? 'yes' : '',
                                            'pretty-message': u.consts('rights').ajaxAdGroupsMultiSave ? 'yes' : ''
                                        },
                                        mix: {
                                            block: 'b-edit-banner2',
                                            elem: 'turbo-landings-params-control'
                                        },
                                        attrs: u.consts('rights').ajaxAdGroupsMultiSave ?
                                            { 'data-err-path': 'turbolanding_href_params' } :
                                            undefined,
                                        maxLength: u.consts('MAX_URL_LENGTH'),
                                        value: hrefParams
                                    }
                                ]
                            }
                        ]
                    }
                ]
            }
        ];
    })
);
