BEM.DOM.decl({ block: 'b-edit-banner2', elem: 'turbo-landings' }, {
    onSetMod: {
        js: function() {
            this._turboLandingsSelectorWrapperElem = this.elem('turbo-landings-control-wrapper');
            this._turboLandingsSelector = this.findBlockInside('turbo-landings-control', 'b-turbo-landings-selector');
            this._turboLandingsParams = this.findBlockOn('turbo-landings-params-control', 'b-href-params');
            this._trackingVariablesSelector = this.findElem('tracking-variables-wrapper');
            this._errorMessage = this.findBlockInside('turbo-landings', 'b-error-pretty-message');

            this.model = this.getParent().model;

            this._checkMandatoryFields();

            this._subMan = BEM.create('i-subscription-manager');

            this._initSubscriptions();

            // включаем анимацию загрузки только для сохраненных ТГО объявлений
            this._turboLandingsSelector.setMod('fetching', this.model.get('ad_type') === 'text' && this.model.get('bid') !== 0);
        }
    },

    destruct: function() {
        this._subMan.dispose();
        this._subMan.destruct();

        this.__base.apply(this, arguments);
    },

    _isAdTypeText: function() {
        return this.model.get('ad_type') === 'text';
    },

    _initSubscriptions: function() {
        var hrefModel = this.model.get('href_model'),
            isActive;

        this._subMan.wrap(hrefModel)
            .on('href', 'change', function() {
                this._setTurbolandingsSelectorActiveStatus();
                this._setTurboSelector();
            }, this)
            .on('url_protocol', 'change', function() {
                this._setTurboSelector();
            }, this)
            .on('hrefHasErrors', 'change', this._setTurboSelector, this);
        this.model.hasField('has_vcard') && this._subMan.wrap(this.model).on('has_vcard', 'change', function() {
            this._setTurbolandingsSelectorActiveStatus();
        }, this);

        // sitelinks есть для ТГО
        if (this.model.hasField('sitelinks')) {
            var sitelinksModel = this.model.get('sitelinks');

            this._subMan.wrap(sitelinksModel)
                .on('change', this._checkTrackingParams, this)
        }

        this._subMan.wrap(this.model)
            .on('ad_type', 'change', function() {
                this._turboLandingsSelector.setMod('vcard-allowed', this._isAdTypeText() ? 'yes' : '');
                this._setTurbolandingsSelectorActiveStatus();
            }, this)
            .on('turbolanding', 'change', function(e, data) {
                var value,
                    hasRecomPrev = this.hasMod(this._turboLandingsSelectorWrapperElem, 'has-turbo');

                if (data.hasOwnProperty('value')) {
                    value = data.value || {};

                    this._turboLandingsSelector.render(value, { smooth: hasRecomPrev });
                    this.delMod(this._turboLandingsSelectorWrapperElem, 'has-turbo');
                    this._errorMessage.clearErrors();
                } else {
                    this._setTurboSelector();
                }
            }, this)
            .on('turbolandingIsActive', 'change', function(e, data) {
                this._turboLandingsSelector.setMod('disabled', data.value ? '' : 'yes');
                this._turboLandingsSelector.setMod('warning', data.value ? '' : 'yes');
            }, this)

            .on('turboRecommendationIsFetching', 'change', function(e, data) {
                this._turboLandingsSelector.setMod('fetching', data.value);
                this._setTurboSelector();
            }, this)
            .on('turbolanding_href_params', 'change', function(e, data) {
                this._turboLandingsParams.setInputValue(data.value);
            }, this)
            .on('has_site', 'change', function() {
                this._setTurbolandingsSelectorActiveStatus();
                this._setTurboSelector();
            }, this);

        this._subMan.wrap(this._turboLandingsSelector).on('change', function(e, data) {
            if (data.id) {
                this.model.set('turbolanding', data);
            } else {
                this.model.clear('turbolanding');
            }

            this._checkTrackingParams();
        }, this);

        this._subMan.wrap(this._turboLandingsParams).on('change', function(e, newValue) {
            this.model.set('turbolanding_href_params', newValue);
        }, this);

        this._setTurbolandingsSelectorActiveStatus();

        isActive = this.model.get('turbolandingIsActive');
        this._turboLandingsSelector.setMod('disabled', isActive ? '' : 'yes');
        this._turboLandingsSelector.setMod('warning', isActive ? '' : 'yes');
    },

    _setTurbolandingsSelectorActiveStatus: function() {
        var hrefModel = this.model.get('href_model'),
            hasVcard = this.model.get('has_vcard'),
            hasSite = this.model.get('has_site'),
            isText = this._isAdTypeText(),
            isActive = hrefModel.get('href').length || (isText && hasVcard) || !hasSite;

        this.model.set('turbolandingIsActive', isActive);
    },

    _checkMandatoryFields: function() {
        var ok = true;

        ok = ok && this.model.hasField('turbolandingIsActive');
        ok = ok && this.model.hasField('turbolanding');
        ok = ok && this.model.hasField('turbolanding_href_params');

        if (!ok) {
            throw new Error('model not suitable for turbo!');
        }
    },

    _checkTrackingParams: function() {
        var hasTurboLink = this.model.hasTurboLink();

        this.toggleMod(this._trackingVariablesSelector, 'hidden', 'yes', !hasTurboLink);
    },

    // Проверяет наличие рекомендации и отображает соответствующий блок трубо.
    _setTurboSelector: function() {
        var turbo = this.model.get('turbolanding').toJSON(),
            recommendation = this.model.get('turboRecommendation').toJSON(),
            recommendationUrl = this._urlTrimSlash(recommendation.url),
            hrefModel = this.model.get('href_model'),
            hasSite = this.model.get('has_site'),
            url = this._getBannerUrl(hrefModel),
            bannerHrefHasError = hrefModel.get('hrefHasErrors'),
            visibleRecommendation = (
                hasSite && // выбран пункт "есть сайт"
                !turbo.href && // нет выбранной турбо-страницы
                !bannerHrefHasError && // указана валидная ссылка на сайт
                recommendation.hasRecommendation && // есть турбо-рекомендация для текущего объявления
                recommendationUrl === url // рекомендация относится к текущей ссылке на сайт
            ),
            time = visibleRecommendation ? recommendation.pageLoadedTimingAvg : undefined,
            hasRecomPrev = this.hasMod(this._turboLandingsSelectorWrapperElem, 'has-turbo');

        if (visibleRecommendation) {
            this._turboLandingsSelector.render(turbo, { time: time, smooth: true });
            this.setMod(this._turboLandingsSelectorWrapperElem, 'has-turbo', true);
        } else if (!turbo.href) {
            this._turboLandingsSelector.render(
                turbo,
                { hasSite: hasSite, smooth: hasRecomPrev }
            );
            this.delMod(this._turboLandingsSelectorWrapperElem, 'has-turbo');
        }
    },

    _getBannerUrl: function(hrefModel) {
        var hrefJson = hrefModel.toJSON(),
            href = hrefJson.href,
            protocol = hrefJson.url_protocol,
            url = protocol + href;

        return this._urlTrimSlash(url);
    },

    _urlTrimSlash: function(url) {
        return url.replace(/\/$/, '');
    }
});
