block('b-edit-banner2').mod('type', 'content-promotion')(
    def()(function() {
        var ctx = this.ctx,
            banner = ctx.banner || {},
            group = ctx.group || {},
            campaign = ctx.campaign || {},
            modelParams = {
                name: 'dm-content-promotion-banner',
                id: banner.modelId || (ctx.modelParams || {}).id || u._.uniqueId('dm-content-promotion-banner'),
                parentName: 'dm-content-promotion-group',
                parentId: group.modelId
            };

        return applyNext({
            urlLengthLimit: ctx.urlLengthLimit,
            bannerIndex: ctx.index,
            canDelete: ctx.canDelete,
            timezone_groups: ctx.timezone_groups,
            new_banner: ctx.new_banner,
            banner: banner,
            group: group,
            errors: banner.errors || {},
            campaign: campaign,
            modelParams: modelParams,
            dmParams: modelParams,
            availableBannerCount: ctx.availableBannerCount,
            tagsProcessed: banner.tags ?
                Object.keys(banner.tags).reduce(function(result, tagId) {
                    var cTag = (campaign.tags || []).filter(function(tag) {
                        return tag.id === tagId;
                    }).pop();

                    return result.concat({
                        id: tagId,
                        value: cTag && cTag.value
                    });
                }, []) : [],
            isSingleGroup: ctx.isSingleGroup,
            errorPath: ctx.errorPath
        });
    }),

    js()(function() {
        return { modelParams: this.modelParams };
    }),

    content()(function() {
        var banner = this.banner,
            group = this.group,
            groupId = group.modelId,
            blockNameByType = u['b-banner-preview2'].getNameByType('content_promotion'),
            contentType = group.content_promotion_content_type || u['content-promotion'].getDefaultContentType(),
            bannerPreviewType = u['content-promotion'].mapContentTypeToBannerPreviewViewType(contentType);

        return {
            elem: 'layout',
            mix: {
                block: 'b-layout-form',
                mods: { inner: 'yes' }
            },
            content: [
                {
                    block: 'b-edit-banner2',
                    elem: 'header',
                    mods: {
                        mode: !this.isSingleGroup && this.bannerIndex == 0 ?
                            'no-border' :
                            undefined
                    },
                    hasHeaderActions: this.ctx.hasHeaderActions,
                    entityTitle: iget2('b-edit-banner2', 'obyavlenie', 'Объявление')
                },
                {
                    block: 'b-layout-table',
                    mods: { layout: 'preview' },
                    content: {
                        elem: 'row',
                        content: [
                            {
                                elem: 'cell',
                                elemMods: { position: 'l' },
                                content: [
                                    {
                                        block: 'b-error-pretty-message',
                                        js: true,
                                        mods: { theme: 'classic' },
                                        mix: {
                                            block: 'b-edit-banner2',
                                            elem: 'pretty-errors-message'
                                        }
                                    },
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'content-promotion-video-href',
                                        attrs: { 'data-err-path': 'video_href' },
                                    },
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'content-promotion-title',
                                        attrs: { 'data-err-path': 'title' },
                                    },
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'content-promotion-description',
                                        attrs: { 'data-err-path': 'description' },
                                    },
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'content-promotion-collection-href',
                                        attrs: { 'data-err-path': 'collection_href' },
                                    },
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'href',
                                        attrs: { 'data-err-path': 'href' },
                                        banner: this.banner,
                                        modelParams: this.modelParams,
                                        urlLengthLimit: this.urlLengthLimit,
                                        promoCodeDomains: this.promoCodeDomains,
                                        optional: true
                                    }
                                ]
                            },
                            { elem: 'gap' },
                            {
                                elem: 'cell',
                                elemMods: { position: 'r' },
                                content: [
                                    {
                                        block: 'b-banner-viewer',
                                        js: {
                                            modelBannerParams: this.modelParams,
                                            modelCampaignParams: {
                                                name: 'm-campaign',
                                                id: this.campaign.cid
                                            }
                                        },
                                        mods: {
                                            'current-view': 'base-image'
                                        },
                                        mix: [{
                                            block: 'b-edit-banner2',
                                            elem: 'banner-viewer'
                                        }],
                                        content: [
                                            {
                                                elem: 'banner',
                                                content: [
                                                    {
                                                        block: 'b-banner-preview2',
                                                        mods: {
                                                            type: 'content-promotion',
                                                            view: bannerPreviewType
                                                        },
                                                        data: u[blockNameByType].fromServer({
                                                            banner: banner,
                                                            group: this.group,
                                                            campaign: this.campaign
                                                        }),
                                                        modelsParams: {
                                                            dmsIds: {
                                                                bannerId: this.modelParams.id,
                                                                groupId: groupId
                                                            }
                                                        }
                                                    },
                                                    {
                                                        block: 'b-banner-preview2-warnings',
                                                        mods: { 'auto-check': 'yes' },
                                                        modelParams: this.modelParams
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                }
            ]
        };
    })
);
