BEM.DOM.decl({ block: 'b-edit-banner2', modName: 'type', modVal: 'content-promotion' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            var modelParams = this.params.modelParams;

            this.groupModel = BEM.MODEL.getOrCreate({
                name: modelParams.parentName,
                id: modelParams.parentId
            });

            this.model.set('ad_type', 'content-promotion').fix();
            this.model.get('href_model').set('required', false);

            this.deleteBtn = this.findBlockOn('delete-btn', 'link');
            this._imageAdLoader = this._initImageAdLoader();
            this._bannerViewer = this.findBlockOn('banner-viewer', 'b-banner-viewer');
            this._videoHrefBlock = this.findBlockInside('b-content-promotion-video-href');
            this._collectionHrefBlock = this.findBlockInside('b-content-promotion-collection-href');

            this.deleteBtn && this._subscriptionManager.on(this.deleteBtn, 'click', this._deleteBanner, this);

            this.bindTo('clear-text', 'click', this._clearBanner);
            this.bindTo('copy-from-prev', 'click', this._copyFromPrev);

            this._subscriptionManager.wrap(this.model)
                .on('content_promotion_content_type', 'change', function(e, data) {
                    var previewType = u['content-promotion'].mapContentTypeToBannerPreviewViewType(data.value);

                    this._bannerViewer.setMod('current-view', previewType);
                    this.setMod('content-type', data.value);
                }, this)
                .on('description', 'change', function(e, data) {
                    this._updateLengthCounter('description', data.value, +u.consts('MAX_BODY_LENGTH_CONTENT_PROMOTION', u.consts('NARROW_SYMBOLS')));
                }, this)
                .on('title', 'change', function(e, data) {
                    this._updateLengthCounter('title', data.value, +u.consts('MAX_TITLE_LENGTH_CONTENT_PROMOTION'), '');
                }, this);
        }
    },

    /**
     * Проверяет, валиден ли данный блок
     * @returns {Boolean}
     */
    isValid: function() {
        return this.model.isValid() && this.groupModel.isValid();
    },

    /**
     * @override {BEM.DOM}
     */
    destruct: function() {
        this['unbindFrom']('clear-text', 'click', this._clearBanner);

        return this.__base.apply(this, arguments);
    },

    /**
     * Удаление баннера
     * @private
     */
    _deleteBanner: function() {
        var handler = this._onRemoveRequest.bind(this);

        if (this.model.isChanged()) {
            BEM.blocks['b-confirm'].open({
                message: iget2('b-edit-banner2', 'vy-deystvitelno-hotite-udalit-108', 'Вы действительно хотите удалить баннер?'),
                onYes: handler
            }, this);
        } else {
            handler();
        }
    },

    /**
     * Проверяет заполненный ли это баннер
     * @param {Object} bannerData – данные баннера
     * @returns {Boolean}
     * @private
     */
    _isBannerFilled: function(bannerData) {
        return bannerData.content_promotion_video_id || bannerData.title || bannerData.description;
    },

    /**
     * Очищает объявление
     */
    _clearBanner: function() {
        var bannerData;

        BEM.blocks['b-metrika2'].reachGoal({
            id: 191494,
            target: 'CLEAR_TEXT'
        });

        bannerData = this.model.toJSON();

        this.model.clear();

        this.model.set('content_promotion_content_type', bannerData.content_promotion_content_type);
        this.model.set('bid', bannerData.bid);
        this.model.get('href_model').set('required', false);
        this._videoHrefBlock.clear();
        this._collectionHrefBlock.clear();
    },

    /**
     * копирует поля объявления из предыдущего
     * @private
     */
    _copyFromPrev: function() {
        var model = this.model,
            modelId = model.get('modelId'),
            data = this.groupModel.getPrevBannerData(modelId, 'content-promotion'),
            copyAction = function() {
                model.update(data);
                this._videoHrefBlock.model.update(data);
                this._collectionHrefBlock.model.update(data);
            }.bind(this);

        if (this._isBannerFilled(model.toJSON())) {
            BEM.blocks['b-confirm'].open({
                message: iget2(
                    'b-edit-banner2',
                    'data-will-be-lost',
                    'Внесенные данные будут потеряны, продолжить?'
                ),
                onYes: copyAction,
                textYes: iget2('b-edit-banner2', 'ok', 'OK'),
                textNo: iget2('b-edit-banner2', 'otmena', 'Отмена')
            }, this);
        } else {
            copyAction();
        }
    },

    /**
     * Обновляет значение счетчика оставшихся символов
     * @param {String} name
     * @param {String} val
     * @param {Number} limit
     * @param {String} narrowSymbols
     * @private
     */
    _updateLengthCounter: function(name, val, limit, narrowSymbols) {
        var counter = this.elem(name + '-length-counter'),
            counterValue;

        val = u.preview.skipSharpSign(val);

        counterValue = u.preview.strCounterWithoutNarrow(
            val.replace(/##/g, ''),
            limit,
            narrowSymbols
        );

        counter.text(counterValue);

        this.toggleMod(counter, 'under-zero', 'yes', counterValue < 0);
    },

    /**
     * Очищает ошибку href поля
     * @private
     */
    _clearHrefError: function() {
        this.findBlockOn('href-error', 'b-model-form-error').delMod('with-error');
    },

    /**
     * Передает внутренним блокам новое доступное для добавления количество баннеров
     * @param {Number} count - доступное для добавления количество баннеров
     */
    updateAvailableBannerCount: function(count) {
        this._imageAdLoader && this._imageAdLoader.updateAvailableBannerCount(count);
    }

});
