block('b-edit-banner2').mod('type', 'cpm-deals')(

    elem('help-text').tag()('p'),

    elem('input-counter').tag()('span'),

    elem('nobr').tag()('span'),

    def()(function() {
        var ctx = this.ctx,
            banner = this.ctx.banner || {},
            group = this.ctx.group || {},
            campaign = this.ctx.campaign || {},
            modelParams = {
                name: 'dm-cpm-deals-banner',
                id: banner.modelId,
                parentName: 'dm-cpm-deals-group',
                parentId: group.modelId
            };

        return applyNext({
            urlLengthLimit: this.ctx.urlLengthLimit,
            bannerIndex: this.ctx.index,
            canDelete: this.ctx.canDelete,
            banner: banner,
            group: group,
            campaign: campaign,
            modelParams: modelParams,
            dmParams: modelParams,
            availableBannerCount: this.ctx.availableBannerCount,
            tagsProcessed: banner.tags ?
                Object.keys(banner.tags).reduce(function(result, tagId) {
                    var cTag = (campaign.tags || []).filter(function(tag) {
                        return tag.id === tagId;
                    }).pop();

                    return result.concat({
                        id: tagId,
                        value: cTag && cTag.value
                    });
                }, []) : [],
            isSingleGroup: this.ctx.isSingleGroup,
            promoCodeDomains: ctx.promoCodeDomains
        })
    }),

    js()(function() {
        return {
            modelParams: this.modelParams,
            promoCodeDomains: this.promoCodeDomains,
            clientId: this.campaign.ClientID
        };
    }),

    content()(function() {
        var banner = this.banner,
            randPhrase = u['dm-base-group'].getRandomActivePhrase(this.group.phrases || []),
            groupId = this.group.modelId,
            blockNameByType = u['b-banner-preview2'].getNameByType('cpm_deals', 'campaign-image');

        return {
            elem: 'layout',
            mix: {
                block: 'b-layout-form',
                mods: { inner: 'yes' }
            },
            content: [
                {
                    block: 'b-edit-banner2',
                    elem: 'header',
                    elemMods: {
                        mode: !this.isSingleGroup && this.bannerIndex == 0 ?
                            'no-border' :
                            undefined
                    }
                },
                {
                    block: 'b-error-pretty-message',
                    js: true,
                    mods: { theme: 'classic' },
                    mix: {
                        block: 'b-edit-banner2',
                        elem: 'pretty-errors-message'
                    }
                },
                {
                    block: 'b-layout-table',
                    mods: { layout: 'preview' },
                    content: {
                        elem: 'row',
                        content: [
                            {
                                elem: 'cell',
                                elemMods: { position: 'l' },
                                content: [
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'image-ad',
                                        attrs: { 'data-err-path': 'creative' },
                                        campaign: this.campaign,
                                        banner: banner,
                                        availableBannerCount: this.availableBannerCount
                                    },
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'href',
                                        attrs: { 'data-err-path': 'href' },
                                        modelParams: this.modelParams,
                                        banner: banner,
                                        urlLengthLimit: this.urlLengthLimit,
                                        canEditDomain: false,
                                        promoCodeDomains: this.promoCodeDomains
                                    },
                                    // DIRECT-72816: Пиксель для сбора Я.Аудитории,
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'pixels',
                                        attrs: { 'data-err-path': 'pixels' },
                                        content: [
                                            {
                                                block: 'b-edit-banner2',
                                                elem: 'audience',
                                                audience: banner.audience,
                                                attrs: { 'data-err-path': '0' }
                                            },
                                            // DIRECT-72816: Пиксель для сбора Я.Аудитории
                                            {
                                                block: 'b-edit-banner2',
                                                elem: 'audits',
                                                audits: banner.audits,
                                                attrs: { 'data-err-path': '1' }
                                            }
                                        ]
                                    },
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'measurers',
                                        banner: banner,
                                        availableMeasurers: u.consts('rights').isMeasurersEnabled,
                                        attrs: { 'data-err-path': 'measurers' },
                                    },
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'tns-id',
                                        available: u.consts('rights').isTNSEnabled['cpm_deals'],
                                        attrs: { 'data-err-path': 'tnsId' },
                                    }
                                ]
                            },
                            { elem: 'gap' },
                            {
                                elem: 'cell',
                                elemMods: { position: 'r' },
                                content: [
                                    {
                                        block: 'b-banner-viewer',
                                        js: {
                                            modelBannerParams: this.modelParams,
                                            modelCampaignParams: {
                                                name: 'dm-cpm-deals-campaign',
                                                id: this.campaign.cid
                                            }
                                        },
                                        mods: {
                                            'current-view': 'creative'
                                        },
                                        mix: [{
                                            block: 'b-edit-banner2',
                                            elem: 'banner-viewer'
                                        }],
                                        content: [
                                            {
                                                elem: 'banner',
                                                content: [
                                                    {
                                                        block: 'b-banner-preview2',
                                                        mods: {
                                                            type: 'cpm-deals',
                                                            view: 'creative'
                                                        },
                                                        data: u[blockNameByType].fromServer({
                                                            banner: banner,
                                                            group: this.group,
                                                            phrase: randPhrase,
                                                            campaign: this.campaign
                                                        }),
                                                        modelsParams: {
                                                            dmsIds: {
                                                                bannerId: this.modelParams.id,
                                                                groupId: groupId,
                                                                phraseId: randPhrase && randPhrase.modelId
                                                            }
                                                        }
                                                    },
                                                    {
                                                        block: 'b-banner-preview2-warnings',
                                                        mods: { 'auto-check': 'yes' },
                                                        modelParams: this.modelParams
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                }
            ]
        };
    })

);
