block('b-edit-banner2').mod('type', 'cpm-yndx-frontpage')(

    elem('help-text').tag()('p'),

    elem('input-counter').tag()('span'),

    elem('nobr').tag()('span'),

    def()(function() {
        var ctx = this.ctx,
            banner = this.ctx.banner || {},
            group = this.ctx.group || {},
            campaign = this.ctx.campaign || {},
            modelParams = {
                name: 'dm-cpm-yndx-frontpage-banner',
                id: banner.modelId,
                parentName: 'dm-cpm-yndx-frontpage-banner-group',
                parentId: group.modelId
            };

        return applyNext({
            urlLengthLimit: this.ctx.urlLengthLimit,
            bannerIndex: this.ctx.index,
            canDelete: this.ctx.canDelete,
            banner: banner,
            group: group,
            campaign: campaign,
            modelParams: modelParams,
            dmParams: modelParams,
            availableBannerCount: this.ctx.availableBannerCount,
            tagsProcessed: banner.tags ?
                Object.keys(banner.tags).reduce(function(result, tagId) {
                    var cTag = (campaign.tags || []).filter(function(tag) {
                        return tag.id === tagId;
                    }).pop();

                    return result.concat({
                        id: tagId,
                        value: cTag && cTag.value
                    });
                }, []) : [],
            isSingleGroup: this.ctx.isSingleGroup,
            promoCodeDomains: ctx.promoCodeDomains
        })
    }),

    js()(function() {
        return {
            modelParams: this.modelParams,
            promoCodeDomains: this.promoCodeDomains,
            clientId: this.campaign.ClientID
        };
    }),

    content()(function() {
        var banner = this.banner,
            groupId = this.group.modelId,
            blockNameByType = u['b-banner-preview2'].getNameByType('cpm_yndx_frontpage', 'campaign-image'),
            isFirst = this.bannerIndex === 0,
            isGroupTypeSupported = u.turbo.isGroupTypeSupported('cpm_yndx_frontpage');

        return {
            elem: 'layout',
            mix: {
                block: 'b-layout-form',
                mods: { inner: 'yes' }
            },
            content: [
                {
                    block: 'b-edit-banner2',
                    elem: 'header',
                    elemMods: {
                        mode: !this.isSingleGroup && this.bannerIndex == 0 ?
                            'no-border' :
                            undefined
                    }
                },
                {
                    block: 'b-layout-table',
                    mods: { layout: 'preview' },
                    content: {
                        elem: 'row',
                        content: [
                            {
                                elem: 'cell',
                                elemMods: { position: 'l' },
                                content: [
                                    {
                                        block: 'b-error-pretty-message',
                                        js: true,
                                        mods: { theme: 'classic' },
                                        mix: {
                                            block: 'b-edit-banner2',
                                            elem: 'pretty-errors-message'
                                        }
                                    },
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'image-ad',
                                        attrs: { 'data-err-path': 'creative' },
                                        campaign: this.campaign,
                                        banner: banner,
                                        availableBannerCount: this.availableBannerCount
                                    },
                                    isGroupTypeSupported && isFirst && {
                                        block: 'b-edit-banner2',
                                        elem: 'turbo-promo'
                                    },
                                    isGroupTypeSupported && {
                                        block: 'b-edit-banner2',
                                        elem: 'contacts-title'
                                    },
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'href',
                                        elemMods: {
                                            visible: (!banner.bid || banner.href) ? 'yes' : 'no'
                                        },
                                        mix: [
                                            {
                                                block: 'b-edit-banner2',
                                                elem: 'model-field',
                                                js: {
                                                    name: 'has_site_enum',
                                                    type: 'mod',
                                                    block: 'b-edit-banner2',
                                                    elem: 'href',
                                                    modName: 'visible'
                                                }
                                            }
                                        ],
                                        attrs: { 'data-err-path': 'href' },
                                        banner: banner,
                                        canEditDomain: false,
                                        modelParams: this.modelParams,
                                        urlLengthLimit: this.urlLengthLimit,
                                        promoCodeDomains: this.promoCodeDomains
                                    },
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'turbo-landings',
                                        clientId: this.campaign.ClientID,
                                        turbolanding: this.banner.turbolanding,
                                        turbolanding_href_params: this.banner.turbolanding_href_params,
                                        isNewGroup: this.ctx.isNewGroup
                                    },
                                    // DIRECT-72816: Пиксель для сбора Я.Аудитории,
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'pixels',
                                        attrs: { 'data-err-path': 'pixels' },
                                        content: [
                                            {
                                                block: 'b-edit-banner2',
                                                elem: 'audience',
                                                audience: banner.audience,
                                                attrs: { 'data-err-path': '0' }
                                            },
                                            // DIRECT-72816: Пиксель для сбора Я.Аудитории
                                            {
                                                block: 'b-edit-banner2',
                                                elem: 'audits',
                                                audits: banner.audits,
                                                attrs: { 'data-err-path': '1' }
                                            }
                                        ]
                                    },
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'measurers',
                                        banner: banner,
                                        availableMeasurers: u.consts('rights').isMeasurersEnabled,
                                        attrs: { 'data-err-path': 'measurers' },
                                    },
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'tns-id',
                                        available: u.consts('rights').isTNSEnabled['cpm_yndx_frontpage'],
                                        attrs: { 'data-err-path': 'tnsId' },
                                    }
                                ]
                            },
                            { elem: 'gap' },
                            {
                                elem: 'cell',
                                elemMods: { position: 'r' },
                                content: [
                                    {
                                        block: 'b-banner-viewer',
                                        js: {
                                            modelBannerParams: this.modelParams,
                                            modelCampaignParams: {
                                                name: 'dm-cpm-yndx-frontpage-campaign',
                                                id: this.campaign.cid
                                            }
                                        },
                                        mods: {
                                            'current-view': 'creative'
                                        },
                                        mix: [{
                                            block: 'b-edit-banner2',
                                            elem: 'banner-viewer'
                                        }],
                                        content: [
                                            {
                                                elem: 'banner',
                                                content: [
                                                    {
                                                        block: 'b-banner-preview2',
                                                        mods: {
                                                            type: 'cpm-yndx-frontpage',
                                                            view: 'creative'
                                                        },
                                                        data: u[blockNameByType].fromServer({
                                                            banner: banner,
                                                            group: this.group,
                                                            campaign: this.campaign
                                                        }),
                                                        modelsParams: {
                                                            dmsIds: {
                                                                bannerId: this.modelParams.id,
                                                                groupId: groupId
                                                            }
                                                        }
                                                    },
                                                    {
                                                        block: 'b-banner-preview2-warnings',
                                                        mods: { 'auto-check': 'yes' },
                                                        modelParams: this.modelParams
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                }
            ]
        };
    })

);
