BEM.DOM.decl({ block: 'b-edit-banner2', modName: 'type', modVal: 'cpm-yndx-frontpage' }, {
    onSetMod: {
        js: function() {
            var modelParams = this.params.modelParams;

            this.__base.apply(this, arguments);

            this.groupModel = BEM.MODEL.getOrCreate({
                name: modelParams.parentName,
                id: modelParams.parentId
            });

            this.model.set('ad_type', 'cpm_yndx_frontpage').fix();

            this._deleteBtn = this.findBlockOn('delete-btn', 'link');
            this._imageAdLoader = this._initImageAdLoader();
            this._bannerViewer = this.findBlockOn('banner-viewer', 'b-banner-viewer');

            this._deleteBtn && this._subscriptionManager.on(this._deleteBtn, 'click', this._deleteBanner, this);

            this._bindImageAdEvents();

            this._initPromoCodeCheck();
        },

        'cpm-group-type': function() {
            this._imageAdLoader.updateItemStates();
            this.model.get('creative').clear();
        }
    },

    /**
     * Проверяет, валиден ли данный блок
     * @returns {Boolean}
     */
    isValid: function() {
        return this.model.isValid() && this.groupModel.isValid();
    },

    /**
     * Передает внутренним блокам новое доступное для добавления количество баннеров
     * @param {Number} count - доступное для добавления количество баннеров
     */
    updateAvailableBannerCount: function(count) {
        this._imageAdLoader && this._imageAdLoader.updateAvailableBannerCount(count);
    },

    /**
     * Удаление баннера
     * @private
     */
    _deleteBanner: function() {
        var handler = this._onRemoveRequest.bind(this);

        if (this.model.isChanged()) {
            BEM.blocks['b-confirm'].open({
                message: iget2('b-edit-banner2', 'vy-deystvitelno-hotite-udalit', 'Вы действительно хотите удалить объявление?'),
                onYes: handler
            }, this);
        } else {
            handler();
        }
    },

    /**
     * Очищает ошибку href поля
     * @private
     */
    _clearHrefError: function() {
        this.findBlockOn('href-error', 'b-model-form-error').delMod('with-error');
    },

    /**
     * Инициализирует контрол для загрузки графического объявления
     * @return {BEM.DOM<b-image-add-loader>|undefined} блок для загрузки файла изображения для графического объявления
     * @private
     */
    _initImageAdLoader: function() {
        var imageAdLoader = this.findBlockOn(this.elem('image-ad-loader'), 'b-image-add-loader');

        imageAdLoader
            .on('change:creatives', function(event, data) {
                var href = data.href || {},
                    firstCreative = data.creatives[0];

                this.model.get('creative').update(firstCreative);

                href.href && this.model.get('href_model').update({
                    href: href.href,
                    domain: href.href_domain,
                    url_protocol: href.protocol
                });

                // если выбрано более 1 креатива, добавляем новые баннеры
                if (data.creatives.length > 1) {
                    this.trigger(
                        'new:banners:needed',
                        data.creatives.slice(1).map(function(el) {
                            var newBannerData = { creative: el };

                            if (href.href) {
                                newBannerData.href = href.href;
                                newBannerData.domain = href.domain;
                                newBannerData.url_protocol = href.protocol;
                            }

                            return newBannerData;
                        })
                    );
                }
            }, this);

        return imageAdLoader;
    },

    /**
     * Подписывается/отписывается на события модели графического объявления
     * @private
     */
    _bindImageAdEvents: function() {
        this._subscriptionManager.wrap(this.model)
            .on('creative', 'change', function() {
                this._imageAdLoader.setCreative(this.model.get('creative').toJSON());
            }, this);
    }
});
