BEM.DOM.decl({ block: 'b-edit-banner2', modName: 'type', modVal: 'cpm' }, {
    onSetMod: {
        js: function() {
            var modelParams = this.params.modelParams;

            this.banner = this.params.banner;

            this.__base.apply(this, arguments);

            this.groupModel = BEM.MODEL.getOrCreate({
                name: modelParams.parentName,
                id: modelParams.parentId
            });

            this.model.set('ad_type', 'cpm_banner').fix();

            this._deleteBtn = this.findBlockOn('delete-btn', 'link');
            this._imageAdLoader = this._initImageAdLoader();
            this._bannerViewer = this.findBlockOn('banner-viewer', 'b-banner-viewer');

            this._deleteBtn && this._subscriptionManager.on(this._deleteBtn, 'click', this._deleteBanner, this);

            this._bindImageAdEvents();

            this._initPromoCodeCheck();

            this.getMod('cpm-group-type') === 'cpm-outdoor' && this._onChangeOutdoor();
        },

        'cpm-group-type': function(name, val) {
            var groupType = this.groupModel.get('cpmGroupType');

            this._imageAdLoader.updateItemStates();
            this.model.get('creative').clear();

            if (!u.turbo.isGroupTypeSupported('cpm_banner', groupType)) {
                this.model.set('has_site_enum', 'yes');
            }

            if (val === 'cpm-outdoor') {
                this._onChangeOutdoor();
            }

            this.setMod(this.elem('audits'), 'cpm-group-type', val);

            this.model.get('creative').set('cpmSubtype', groupType);

            this.updateMeasurers(
                u.consts('rights').isMeasurersEnabled,
                u.consts('rights').isTNSEnabled[groupType]
            )
        }
    },

    updateMeasurers: function(availableMeasurers, isTNSEnabled) {
        u.measurers.getMeasurerSystems().forEach(function(measurer) {
            this.setMod(
                this.elem('measurers-table-row', 'measurer', u.beminize(measurer)),
                'hidden',
                !availableMeasurers || !availableMeasurers[measurer] ? 'yes' : ''
            );
        }, this);

        this.setMod(this.elem('measurers'), 'available', availableMeasurers ? 'yes' : '');
        this.setMod(this.elem('tns-id'), 'available', isTNSEnabled ? 'yes' : '');
    },

    /**
     * Проверяет, валиден ли данный блок
     * @returns {Boolean}
     */
    isValid: function() {
        return this.model.isValid() && this.groupModel.isValid();
    },

    /**
     * Передает внутренним блокам новое доступное для добавления количество баннеров
     * @param {Number} count - доступное для добавления количество баннеров
     */
    updateAvailableBannerCount: function(count) {
        this._imageAdLoader && this._imageAdLoader.updateAvailableBannerCount(count);
    },

    _onChangeOutdoor: function() {
        if (this._needCheck) return;

        this._subscriptionManager.wrap(this.model)
            .on('creative', 'change', function() {
                if (this.groupModel.get('cpmGroupType') === 'cpm_outdoor') {
                    this._checkOutdoorWarnings();
                }
            }, this);

        this._subscriptionManager.wrap(this.groupModel)
            .on('outdoorFormats', 'change', this._checkOutdoorWarnings, this)
            .on('cpmGroupType', 'change', function() {
                this._updateOutdoorWarnings(true);
            }, this);

        this._needCheck = true;
    },

    _checkOutdoorWarnings: function() {
        var modelCreative = this.model.get('creative'),
            pageFormats = (this.groupModel.get('outdoorFormats') || []).reduce(function(res, item) {
                var duration = item.duration || 0;

                res[duration] || (res[duration] = []);
                res[duration].push(item.resolution);

                return res;
            }, {}),
            creativeResolutions = modelCreative.get('outdoorResolutions'),
            duration = modelCreative.get('duration'),
            needWarning = !u._.intersection(pageFormats[duration] || pageFormats[0], creativeResolutions).length;

        Object.keys(pageFormats).length && this._updateOutdoorWarnings(needWarning);
    },

    _updateOutdoorWarnings: function(needWarning) {
        var modelCreative = this.model.get('creative'),
            creativeResolutions = modelCreative.get('outdoorResolutions'),
            duration = modelCreative.get('duration');

        BEM.DOM.update(this.elem('warning-outdoor-banner'), BEMHTML.apply({
            block: 'warning-message',
            text: needWarning && creativeResolutions.length ?
                iget2('b-edit-banner2', 'warning-for-outdoor-banner', 'Для начала показа объявления выберите подходящие щиты на карте: {resolutions}px, {duration}&nbsp;сек', {
                    resolutions: creativeResolutions.join('px, '),
                    duration: duration
                }) :
                ''
        }));
    },

    /**
     * Удаление баннера
     * @private
     */
    _deleteBanner: function() {
        var handler = this._onRemoveRequest.bind(this);

        if (this.model.isChanged()) {
            BEM.blocks['b-confirm'].open({
                message: iget2('b-edit-banner2', 'vy-deystvitelno-hotite-udalit', 'Вы действительно хотите удалить объявление?'),
                onYes: handler
            }, this);
        } else {
            handler();
        }
    },

    /**
     * Очищает ошибку href поля
     * @private
     */
    _clearHrefError: function() {
        this.findBlockOn('href-error', 'b-model-form-error').delMod('with-error');
    },

    /**
     * Инициализирует контрол для загрузки графического объявления
     * @return {BEM.DOM<b-image-add-loader>|undefined} блок для загрузки файла изображения для графического объявления
     * @private
     */
    _initImageAdLoader: function() {
        var imageAdLoader = this.findBlockOn(this.elem('image-ad-loader'), 'b-image-add-loader');

        if (imageAdLoader) {
            this._subscriptionManager
                .on(imageAdLoader, 'change:creatives', function(event, data) {
                    var href = data.href || {},
                        firstCreative = data.creatives[0];

                    this.model.get('creative').update(firstCreative);

                    href.href && this.model.get('href_model').update({
                        href: href.href,
                        domain: href.href_domain,
                        url_protocol: href.protocol
                    });

                    // если выбрано более 1 креатива, добавляем новые баннеры
                    if (data.creatives.length > 1) {
                        this.trigger(
                            'new:banners:needed',
                            data.creatives.slice(1).map(function(el) {
                                var newBannerData = { creative: el };

                                if (href.href) {
                                    newBannerData.href = href.href;
                                    newBannerData.domain = href.domain;
                                    newBannerData.url_protocol = href.protocol;
                                }

                                return newBannerData;
                            })
                        );
                    }
                }, this);
        }

        return imageAdLoader;
    },

    /**
     * Подписывается/отписывается на события модели графического объявления
     * @private
     */
    _bindImageAdEvents: function() {
        this._subscriptionManager.wrap(this.model)
            .on('creative', 'change', function() {
                this._imageAdLoader.setCreative(this.model.get('creative').toJSON());
            }, this);
    }
});
