block('b-edit-banner2').mod('type', 'dynamic-media')(
    elem('help-text').tag()('p'),

    elem('input-counter').tag()('span'),

    elem('nobr').tag()('span'),

    def()(function() {
        var banner = this.ctx.banner || {},
            group = this.ctx.group || {},
            campaign = this.ctx.campaign || {};

        return applyNext({
            banner: banner,
            group: group,
            campaign: this.ctx.campaign || {},
            errors: banner.errors || {},
            modelParams: {
                name: 'dm-dynamic-media-banner',
                id: banner.modelId,
                parentName: 'dm-dynamic-media-group',
                parentId: group.modelId
            },
            tagsProcessed: banner.tags ?
                Object.keys(banner.tags).reduce(function(result, tagId) {
                    var cTag = (campaign.tags || []).filter(function(tag) { return tag.id === tagId; }).pop();

                    return result.concat({
                        id: tagId,
                        value: cTag && cTag.value
                    });
                }, []) :
                [],
            isSingleGroup: this.ctx.isSingleGroup
        })
    }),

    js()(function() {
        return {
            groupId: this.group.modelId,
            modelParams: this.modelParams
        };
    }),

    content()(function() {
        var banner = this.banner;

        return {
            elem: 'layout',
            mix: {
                block: 'b-layout-form',
                mods: { inner: 'yes' }
            },
            content: [
                {
                    elem: 'creative',
                    creative: banner.creative,
                    bid: banner.bid
                },
                {
                    elem: 'controls',
                    content: [
                        {
                            block: 'button',
                            mods: { theme: 'pseudo' },
                            mix: {
                                block: 'b-edit-banner2',
                                elem: 'edit-button'
                            },
                            content: iget2('b-edit-banner2', 'zamenit', 'Заменить')
                        },
                        banner.BannerID == 0 && {
                            block: 'button',
                            mods: { theme: 'pseudo' },
                            mix: {
                                block: 'b-edit-banner2',
                                elem: 'remove-button'
                            },
                            content: iget2('b-edit-banner2', 'udalit', 'Удалить')
                        }
                    ]
                }
            ]
        };
    }),

    elem('creative').content()(function() {
        return {
            block: 'b-dynamic-media-creative',
            mods: { view: 'multiedit' },
            creative: this.ctx.creative,
            bid: this.ctx.bid
        };
    })
);
