BEM.DOM.decl({ block: 'b-edit-banner2', modName: 'type', modVal: 'dynamic-media' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            u.graspSelf.call(this, {
                _edit: 'button on edit-button',
                _remove: '? button on remove-button'
            });

            this._bindInteractions();
            this._bindModel();
        }
    },

    _bindInteractions: function() {
        this._subscriptionManager.on(this._edit, 'click', function() {
            this.trigger('edit', {
                modelId: this.model.get('modelId'),
                groupId: this.params.groupId
            } );
        }, this);

        this._remove && this._subscriptionManager.on(this._remove, 'click', function() {
            this._onRemoveRequest();
        }, this);
    },

    _bindModel: function() {
        this._subscriptionManager.on(this.model, 'creative', 'change', function() {
            BEM.DOM.update(this.findElem('creative'), BEMHTML.apply({
                block: 'b-edit-banner2',
                mods: { type: 'dynamic-media' },
                elem: 'creative',
                creative: this.model.get('creative').toJSON(),
                bid: this.model.get('bid')
            }));
        }, this);
    },

    destruct: function() {
        this.model.destruct();

        return this.__base.apply(this, arguments);
    }
});
