block('b-edit-banner2').mod('type', 'dynamic')(

    elem('help-text').tag()('p'),

    elem('input-counter').tag()('span'),

    elem('nobr').tag()('span'),

    def()(function() {
        var ctx = this.ctx,
            banner = this.ctx.banner || {},
            vcard = u._.extend({}, banner.vcard),
            group = this.ctx.group || {},
            campaign = this.ctx.campaign || {};

        banner.hasCopyFromPrev = false; //у динамических объявлений не может быть копирования из предыдущего
        banner.title = u.dynamicGroupsData.getBannerTitle();

        return applyNext({
            'mods.with-vcard': ctx.withVCard ? 'yes' : '',
            'mods.for-banner-type': u.escapeHTML(banner.banner_type) || 'desktop',
            //порядок баннера в группе
            bannerIndex: this.ctx.index,
            //можем удалить баннер
            canDelete: this.ctx.canDelete,
            banner: banner,
            group: group,
            campaign: this.ctx.campaign || {},
            errors: banner.errors || {},
            modelParams: {
                name: 'dm-dynamic-banner',
                id: banner.modelId,
                parentName: 'dm-dynamic-group',
                parentId: group.modelId
            },
            vcard: vcard,
            tagsProcessed: banner.tags ?
                Object.keys(banner.tags).reduce(function(result, tagId) {
                    var cTag = (campaign.tags || []).filter(function(tag) {
                        return tag.id === tagId;
                    }).pop();

                    return result.concat({
                        id: tagId,
                        value: cTag && cTag.value
                    });
                }, []) : [],
            canEditDomain: this.ctx.canEditDomain,
            isSingleGroup: this.ctx.isSingleGroup,
            errorPath: u.error.createPathBuilder(this.ctx.errorPath)
        });
    }),

    js()(function() {
        return {
            modelParams: this.modelParams
        };
    }),

    content()(function() {

        return {
            elem: 'layout',
            mix: {
                block: 'b-layout-form',
                mods: { inner: 'yes' }
            },
            content: [
                {
                    block: 'b-edit-banner2',
                    elem: 'header',
                    elemMods: { mode: !this.isSingleGroup && this.bannerIndex == 0 ? 'no-border' : undefined },
                    hasHeaderActions: this.ctx.hasHeaderActions,
                    withMobile: false
                },
                {
                    block: 'b-error-message',
                    js: { path: this.ctx.errorPath }
                },
                {
                    block: 'b-layout-table',
                    mods: { layout: 'preview' },
                    content: {
                        elem: 'row',
                        content: [
                            {
                                elem: 'cell',
                                elemMods: { position: 'l' },
                                content: [
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'dynamic-title'
                                    },
                                    {
                                        block: 'b-error-message', //виртуальное поле text_lang про несоответствия языка и региона
                                        js: { path: this.errorPath('text_lang') }
                                    },
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'body',
                                        elemMods: { type: 'error2' }
                                    },
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'additions',
                                        mediaType: 'dynamic',
                                        elemMods: { type: 'error2' }
                                    }
                                ]
                            },
                            {
                                elem: 'gap'
                            },
                            {
                                elem: 'cell',
                                elemMods: { position: 'r' },
                                content: {
                                    block: 'b-edit-banner2',
                                    elemMods: this.mods,
                                    elem: 'preview'
                                }
                            }
                        ]
                    }
                },
                this.ctx.withVCard && {
                    block: 'b-edit-banner2',
                    elem: 'vcard',
                    modelParams: this.modelParams,
                    isVCardOpen: this.banner.is_vcard_open
                }
            ]
        };
    })
);
