BEM.DOM.decl({ block: 'b-edit-banner2', modName: 'type', modVal: 'dynamic' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this.deleteBtn = this.findBlockOn('delete-btn', 'link');
            this._vcard = this.findBlockInside('b-vcard-control');

            this.geoModel = BEM.MODEL.getOrCreate({
                name: 'm-geo-regions',
                id: this.params.modelParams.parentId,
                parentName: 'dm-dynamic-group',
                parentId: this.params.modelParams.parentId
            });

            this.groupModel = BEM.MODEL.getOne({
                name: 'dm-dynamic-group',
                id: this.params.modelParams.parentId
            });

            // пишем ссылку из домена
            var href = this.groupModel.get('main_domain');
            if (href) {
                this._updateDomain(href);
            }

            this.deleteBtn && this.deleteBtn.on('click', this._deleteBanner, this);

            this._bindModelEvents();
            this._geoRestrictionsRequest = BEM.blocks['i-mass-request-factory'].getInstanceFor('getGeoRestrictions');
            this._getGeoRestrictions();

            this.model.on('destruct', function() {
                this.destruct();
            }, this);
        }
    },

    /**
     * Обновляет поля, ответственные за ссылку в модели объявления
     * @param {String} href
     */
    _updateDomain: function(href) {
        this.model.update({
            domain: href,
            href_model: {
                href: href,
                domain: href,
                url_protocol: 'http://'
            }
        });
    },

    /**
     * Удаление баннера
     * @private
     */
    _deleteBanner: function() {
        var handler = this._onRemoveRequest.bind(this);

        //если визитка не пустая - то даже если ее не меняли - покажем предупреждение
        if (this.model.isChanged() || !this._isVCardEmpty()) {
            BEM.blocks['b-confirm'].open({
                message: iget2('b-edit-banner2', 'vy-deystvitelno-hotite-udalit', 'Вы действительно хотите удалить объявление?'),
                onYes: handler
            }, this);
        } else {
            handler();
        }
    },

    _isVCardEmpty: function() {
        if (!this.hasMod('with-vcard', 'yes')) return true;

        return this.model.get('isVCardEmpty');
    },

    /**
     * Возвращает промис ограничения по паре текст/регионы
     * @returns {Object}
     * @private
     */
    _getGeoRestrictions: function() {
        var _this = this,
            text = this.model.get('body');

        this._geoRestrictionsRequest.get({
            text: text,
            geo: this.geoModel.get('geo')
        }, function(data) {
            var warning;

            if (data.warning) {
                warning = data.warning;
            } else if (data.error) {
                warning = data.error.for_banner;
            }

            _this.model.trigger('geo-check-error', { messages: warning });
        }, function() {
            _this.model.trigger('geo-check-error', { messages: '' });
        });

        return this;
    },

    _bindModelEvents: function() {
        this._subscriptionManager
            .on(this.geoModel, 'change', this._getGeoRestrictions, this)
            .on(this.model, 'body', 'change', function() {
                if (!this.getFieldBlock('body').input.hasMod('focused')) {
                    this._getGeoRestrictions();
                }
            }, this)
            .on(this.groupModel, 'main_domain', 'change', function(e, data) {
                this._updateDomain(data.value);
            }, this);

        this.bindTo('clear-text', 'click', this._clearText);

        this._subscriptionManager.wrap(this.getFieldBlock('body').input)
            .on('change', function(e) {
                this._updateLengthCounter('body', e.block.val(), +u.consts('MAX_BODY_LENGTH'));
            }, this)
            .on('blur', function(e) {
                this._getGeoRestrictions();
            }, this);

        return this;
    },

    destruct: function() {
        this.unbindFrom('clear-text', 'click', this._clearText);

        this.model.destruct();

        return this.__base.apply(this, arguments);
    },

    /**
     * Проверяет, валиден ли данный блок
     * @returns {Boolean}
     */
    isValid: function() {
        return this.model.isValid();
    },

    /**
     * Обновляет значение счетчика оставшихся символов
     * @param {String} name
     * @param {String} val
     * @param {Number} limit
     * @private
     */
    _updateLengthCounter: function(name, val, limit) {
        var counter = this.elem(name + '-length-counter'),
            counterValue;

        val = u.preview.skipSharpSign(val);

        if (name === 'body') {
            counterValue = u.preview.strCounterWithoutNarrow(
                val,
                limit,
                u.consts('NARROW_SYMBOLS')
            );
        } else {
            counterValue = limit - (val.length || 0);
        }

        counter.text(counterValue);

        this.toggleMod(counter, 'under-zero', 'yes', counterValue < 0);
    },

    /**
     * Очищает текст, ссылку и адрес в модели
     */
    _clearText: function() {
        this.model.update({
            body: '',
            callouts: []
        });

        //метрика
        try {
            yaCounter191494.reachGoal('CLEAR_TEXT');
        } catch (e) { }

        this.model.get('image_model').clear();
        this.model.get('sitelinks').clear();

        this._vcard && this._vcard.clear();
    }
});
