block('b-edit-banner2').mod('type', 'mcbanner')(
    def()(function() {
        var ctx = this.ctx,
            banner = this.ctx.banner || {},
            group = this.ctx.group || {},
            campaign = this.ctx.campaign || {},
            modelParams = {
                name: 'm-banner',
                id: banner.modelId,
                parentName: 'dm-mcbanner-group',
                parentId: group.modelId
            };

        return applyNext({
            urlLengthLimit: this.ctx.urlLengthLimit,
            bannerIndex: this.ctx.index,
            canDelete: this.ctx.canDelete,
            timezone_groups: this.ctx.timezone_groups,
            new_banner: this.ctx.new_banner,
            banner: banner,
            group: group,
            campaign: campaign,
            modelParams: modelParams,
            dmParams: modelParams,
            availableBannerCount: this.ctx.availableBannerCount,
            tagsProcessed: banner.tags ?
                Object.keys(banner.tags).reduce(function(result, tagId) {
                    var cTag = (campaign.tags || []).filter(function(tag) {
                        return tag.id === tagId;
                    }).pop();

                    return result.concat({
                        id: tagId,
                        value: cTag && cTag.value
                    });
                }, []) : [],
            isSingleGroup: this.ctx.isSingleGroup,
            errorPath: u.error.createPathBuilder(this.ctx.errorPath)
        });
    }),

    js()(function() {
        return { modelParams: this.modelParams };
    }),

    content()(function() {
        var banner = this.banner,
            randPhrase = u['dm-base-group'].getRandomActivePhrase(this.group.phrases || []),
            groupId = this.group.modelId,
            blockNameByType = u['b-banner-preview2'].getNameByType(
                'mcbanner',
                'base-image'
            );

        return {
            elem: 'layout',
            mix: {
                block: 'b-layout-form',
                mods: { inner: 'yes' }
            },
            content: [
                {
                    block: 'b-edit-banner2',
                    elem: 'header',
                    mods: {
                        mode: !this.isSingleGroup && this.bannerIndex == 0 ?
                            'no-border' :
                            undefined
                    },
                    hasHeaderActions: this.ctx.hasHeaderActions,
                    entityTitle: iget2('b-edit-banner2', 'banner', 'Баннер')
                },
                {
                    block: 'b-error-message',
                    js: { path: this.ctx.errorPath }
                },
                {
                    block: 'b-layout-table',
                    mods: { layout: 'preview' },
                    content: {
                        elem: 'row',
                        content: [
                            {
                                elem: 'cell',
                                elemMods: { position: 'l' },
                                content: [
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'image-ad2',
                                        size: { width: 240, height: 400 },
                                        campaign: this.campaign,
                                        banner: banner,
                                        availableBannerCount: this.availableBannerCount,
                                        errorPath: this.errorPath('image_ad')
                                    },
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'href2',
                                        modelParams: this.modelParams,
                                        banner: banner,
                                        urlLengthLimit: this.urlLengthLimit,
                                        canEditDomain: false,
                                        errorPath: this.errorPath('href')
                                    }
                                ]
                            },
                            { elem: 'gap' },
                            {
                                elem: 'cell',
                                elemMods: { position: 'r' },
                                content: [
                                    {
                                        block: 'b-banner-viewer',
                                        js: {
                                            modelBannerParams: this.modelParams,
                                            modelCampaignParams: {
                                                name: 'm-campaign',
                                                id: this.campaign.cid
                                            }
                                        },
                                        mods: {
                                            'current-view': 'base-image'
                                        },
                                        mix: [{
                                            block: 'b-edit-banner2',
                                            elem: 'banner-viewer'
                                        }],
                                        content: [
                                            {
                                                elem: 'banner',
                                                content: [
                                                    {
                                                        block: 'b-banner-preview2',
                                                        mods: {
                                                            type: 'mcbanner',
                                                            view: 'base-image'
                                                        },
                                                        data: u[blockNameByType].fromServer({
                                                            banner: banner,
                                                            group: this.group,
                                                            phrase: randPhrase,
                                                            campaign: this.campaign
                                                        }),
                                                        modelsParams: {
                                                            dmsIds: {
                                                                bannerId: this.modelParams.id,
                                                                groupId: groupId,
                                                                phraseId: randPhrase && randPhrase.modelId
                                                            }
                                                        }
                                                    },
                                                    {
                                                        block: 'b-banner-preview2-warnings',
                                                        mods: { 'auto-check': 'yes' },
                                                        modelParams: this.modelParams
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                }
            ]
        };
    })
);
