BEM.DOM.decl({ block: 'b-edit-banner2', modName: 'type', modVal: 'mcbanner' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            var modelParams = this.params.modelParams;

            this.groupModel = BEM.MODEL.getOrCreate({
                name: modelParams.parentName,
                id: modelParams.parentId
            });

            this.model.set('ad_type', 'mcbanner').fix();

            this.deleteBtn = this.findBlockOn('delete-btn', 'link');
            this._imageAdLoader = this._initImageAdLoader();
            this._bannerViewer = this.findBlockOn('banner-viewer', 'b-banner-viewer');

            this.deleteBtn && this._subscriptionManager.on(this.deleteBtn, 'click', this._deleteBanner, this);

            this['bindTo']('clear-text', 'click', this._clearText);

            this._bindImageAdEvents();
        }
    },

    /**
     * Проверяет, валиден ли данный блок
     * @returns {Boolean}
     */
    isValid: function() {
        return this.model.isValid() && this.groupModel.isValid();
    },

    /**
     * @override {BEM.DOM}
     */
    destruct: function() {
        this['unbindFrom']('clear-text', 'click', this._clearText);

        return this.__base.apply(this, arguments);
    },

    /**
     * Удаление баннера
     * @private
     */
    _deleteBanner: function() {
        var handler = this._onRemoveRequest.bind(this);

        if (this.model.isChanged()) {
            BEM.blocks['b-confirm'].open({
                message: iget2('b-edit-banner2', 'vy-deystvitelno-hotite-udalit-108', 'Вы действительно хотите удалить баннер?'),
                onYes: handler
            }, this);
        } else {
            handler();
        }
    },

    /**
     * Проверяет заполненный ли это баннер
     * @param {Object} bannerData – данные баннера
     * @returns {Boolean}
     * @private
     */
    _isBannerFilled: function(bannerData) {
        var isNotEmpty = function(fields, obj) {
            return fields.some(function(field) { return obj[field]; });
        };

        return bannerData.image_model && bannerData.image_model.image ||
            bannerData.href_model && isNotEmpty(['domain', 'domain_redir', 'href'], bannerData.href_model) ||
            bannerData.image_ad && bannerData.image_ad.hash ||
            bannerData.creative && bannerData.creative.creative_id;
    },

    /**
     * Очищает текст, ссылку и адрес в модели
     */
    _clearText: function() {
        BEM.blocks['b-metrika2'].reachGoal({
            id: 191494,
            target: 'CLEAR_TEXT'
        });

        this.model.get('image_model').clear();
        this.model.get('href_model').clear();
        this.model.get('creative') && this.model.get('creative').clear();
    },

    /**
     * Очищает ошибку href поля
     * @private
     */
    _clearHrefError: function() {
        this.findBlockOn('href-error', 'b-model-form-error').delMod('with-error');
    },

    /**
     * Передает внутренним блокам новое доступное для добавления количество баннеров
     * @param {Number} count - доступное для добавления количество баннеров
     */
    updateAvailableBannerCount: function(count) {
        this._imageAdLoader && this._imageAdLoader.updateAvailableBannerCount(count);
    },

    /**
     * Инициализирует контрол для загрузки графического объявления
     * @return {BEM.DOM<b-image-add-loader>|undefined} блок для загрузки файла изображения для графического объявления
     * @private
     */
    _initImageAdLoader: function() {
        var imageAdLoader = this.findBlockOn(this.elem('image-ad-loader'), 'b-image-add-loader');

        imageAdLoader
            .on('_loading_*', this._onLoadingImages, this)
            .on('change:creatives', function(e, data) {
                var href = data.href || {},
                    creatives = data.creatives || data.images;

                if (data.images) {
                    this.model.clear('creative');
                    this.model.get('image_ad').update(data.images[0]);
                }

                if (data.creatives) {
                    this.model.clear('image_ad');
                    this.model.get('creative').update(data.creatives[0]);
                }

                href.href && this.model.get('href_model').update({
                    href: href.href,
                    domain: href.domain,
                    url_protocol: href.protocol
                });

                // если выбрано более 1 креатива, добавляем новые баннеры
                creatives.length > 1 && this.trigger(
                    'new:banners:needed',
                    creatives.slice(1).map(function(el) {
                        var newBannerData = { ad_type: 'image_ad' };

                        data.images && (newBannerData.image_ad = el);
                        data.creatives && (newBannerData.creative = el);

                        if (href.href) {
                            newBannerData.href = href.href;
                            newBannerData.domain = href.domain;
                            newBannerData.url_protocol = href.protocol;
                        }

                        return newBannerData;
                    })
                );

                if (data.errors) {
                    BEM.blocks['b-confirm'].open({
                        message: data.errors,
                        type: 'alert',
                        title: data.errors.length > 1 ?
                            iget2('b-edit-banner2', 'title-errors-upload-images', 'Следующие файлы не были загружены') :
                            iget2('b-edit-banner2', 'title-errors-upload-image', 'Файл не был загружен'),
                        withBullets: data.errors.length > 1
                    });
                }
            }, this);

        return imageAdLoader;
    },

    /**
     * Подписывается/отписывается на события модели графического объявления
     * @private
     */
    _bindImageAdEvents: function() {
        this._subscriptionManager.wrap(this.model)
            .on('image_ad', 'clear', function() {
                this._imageAdLoader.resetImage();
            }, this)
            .on('image_ad', 'change', function() {
                this._imageAdLoader.setImage(this.model.get('image_ad').toJSON());
            }, this)
            .on('creative', 'change', function() {
                this._imageAdLoader.setCreative(this.model.get('creative').toJSON());
            }, this);
    }
});
