block('b-edit-banner2').mod('type', 'mobile-content')(
    elem('help-text').tag()('p'),

    elem('input-counter').tag()('span'),

    elem('nobr').tag()('span'),

    def()(function() {
        var banner = this.ctx.banner || {},
            group = this.ctx.group || {},
            campaign = this.ctx.campaign || {},
            tagsProcessed = banner.tags ?
                Object.keys(banner.tags).reduce(function(result, tagId) {
                    var cTag = (campaign.tags || []).filter(function(tag) {
                        return tag.id === tagId;
                    }).pop();

                    return result.concat({
                        id: tagId,
                        value: cTag && cTag.value
                    });
                }, []) :
                [];

        // для первого этапа копирование из предыдущего не делаем
        banner.hasCopyFromPrev = false;
        banner.mobileAppTrackerHref = this.ctx.mobileAppTrackerHref;

        return applyNext({
            // ad_type - тип объявления. Может принимать значения: 'text', 'image_ad', 'cpc_video'
            'mods.ad-type': u.beminize(u.escapeHTML(banner.ad_type) || 'text'),
            mediaType: 'mobile_content',
            urlLengthLimit: this.ctx.urlLengthLimit,
            //порядок баннера в группе
            bannerIndex: this.ctx.index,
            //можем удалить баннер
            canDelete: this.ctx.canDelete,
            availableBannerCount: this.ctx.availableBannerCount,
            banner: banner,
            group: group,
            campaign: this.ctx.campaign || {},
            errors: banner.errors || {},
            isRmpCpcVideoEnabled: this.ctx.isRmpCpcVideoEnabled,
            modelParams: {
                name: 'b-edit-banner2_type_mobile-content',
                id: banner.modelId,
                parentName: 'b-edit-group_type_mobile-content',
                parentId: group.modelId,
                data: banner,
                isNewBanner: banner.isNewBanner
            },
            dmParams: {
                name: 'dm-mobile-content-banner',
                id: banner.modelId,
                parentName: 'dm-mobile-content-group',
                parentId: group.modelId
            },
            canEditDomain: this.ctx.canEditDomain,
            tagsProcessed: tagsProcessed,
            isSingleGroup: this.ctx.isSingleGroup
        })
    }),

    js()(function() {
        return {
            modelParams: this.modelParams,
            campaign: this.ctx.campaign
        };
    }),

    content()(function() {
        var strategyToCheck = u._.get(this.ctx, 'campaign.strategy.search', {}),
            banner = this.banner,
            isCreative = !u['b-image-add-loader'].isEmptyCreative(banner.creative);

        if (strategyToCheck.name === 'stop') {
            strategyToCheck = this.ctx.campaign.net || {};
        }

        return {
            elem: 'layout',
            mix: {
                block: 'b-layout-form',
                mods: { inner: 'yes' }
            },
            content: [
                {
                    block: 'b-edit-banner2',
                    elem: 'header',
                    elemMods: { mode: !this.isSingleGroup && this.bannerIndex == 0 ? 'no-border' : undefined },
                    hasHeaderActions: this.ctx.hasHeaderActions,
                    withMobile: false
                },
                {
                    block: 'b-layout-table',
                    mods: { layout: 'preview' },
                    content: {
                        elem: 'row',
                        content: [
                            {
                                elem: 'cell',
                                elemMods: { position: 'l' },
                                content: [
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'ad-type'
                                    },
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'image-ad',
                                        attrs: { 'data-err-path': isCreative ? 'creative' : 'image_ad' }
                                    },
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'mobile-content-title'
                                    },
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'body'
                                    },
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'mobile-content-tracking-href',
                                        required: strategyToCheck.name === 'autobudget_avg_cpi' ||
                                            (strategyToCheck.name === 'autobudget' && strategyToCheck.goal_id === '4'),
                                        banner: this.ctx.banner
                                    },
                                    [
                                        u.consts('isMobile') ? '' : {
                                            block: 'b-edit-banner2',
                                            elem: 'addition-image'
                                        },
                                        (u.consts('rights').enableVideoInMobileCampains ||
                                            this.banner.video_resources && this.banner.video_resources.id) && {
                                                block: 'b-edit-banner2',
                                                elem: 'addition-video'
                                            },
                                        {
                                            block: 'b-edit-banner2',
                                            elem: 'action-type'
                                        },
                                        {
                                            block: 'b-edit-banner2',
                                            elem: 'age-label'
                                        },
                                        {
                                            block: 'b-edit-banner2',
                                            elem: 'mobile-content-additions'
                                        }
                                    ]
                                ]
                            },
                            {
                                elem: 'gap'
                            },
                            {
                                elem: 'cell',
                                elemMods: { position: 'r' },
                                content: [
                                    {
                                        block: 'b-edit-banner2',
                                        elemMods: this.mods,
                                        elem: 'preview'
                                    },
                                    {
                                        block: 'b-mobile-content-creative-adviser',
                                        mix: [
                                            {
                                                block: 'b-edit-banner2',
                                                elem: 'model-field',
                                                js: {
                                                    name: 'hideSizeAdviser',
                                                    block: 'b-mobile-content-creative-adviser',
                                                    modName: 'hidden',
                                                    type: 'mod'
                                                }
                                            }
                                        ],
                                        mods: { hidden: 'yes' },
                                        modelParams: this.modelParams
                                    }
                                ]
                            }
                        ]
                    }
                }
            ]
        };
    })
);
