BEM.DOM.decl({ block: 'b-edit-banner2', modName: 'type', modVal: 'mobile-content' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._deleteBtn = this.findBlockOn('delete-btn', 'link');

            this._geoModel = BEM.MODEL.getOrCreate({
                name: 'm-geo-regions',
                id: this.params.modelParams.parentId,
                parentName: 'dm-mobile-content-group',
                parentId: this.params.modelParams.parentId
            });

            this._geoRestrictionsRequest = BEM.blocks['i-mass-request-factory'].getInstanceFor('getGeoRestrictions');
            this._getGeoRestrictions();

            this._imageAdLoader = this._initImageAdLoader();
            this._bannerViewer = this.findBlockOn('banner-viewer', 'b-banner-viewer');
            this.model.on('ad_type', 'change', function() {
                this.model.get('image_ad').clear();
                this.model.get('creative').clear();
            }, this);
            this._videoExtention = this.findBlockInside('addition-video', 'b-video-extension');

            this.bannerDM = this.model.getDM()['dm-mobile-content-banner'];

            this.model.init();
            this._initEvents();
        },
        'ad-type': function(modName, modVal) {
            switch (modVal) {
                case 'cpc-video':
                    this.elem('image-ad').attr('data-err-path', 'creative');
                    break;
                case 'image-ad':
                    this.elem('image-ad').attr('data-err-path', 'image_ad');
                    break;
            }

            this._imageAdLoader.updateItemStates();
        }
    },

    /**
     * Подписывается на события
     * @private
     */
    _initEvents: function() {
        var mobileContentModel = this.model.getMobileContentModelForGroup();

        this._deleteBtn && this._deleteBtn.on('click', this._deleteBanner, this);

        this.bindTo('clear-text', 'click', this._clearText);

        this._subscriptionManager
            .on(this.model, 'destruct', function() {
                this.destruct();
            }, this);

        this._subscriptionManager.wrap(this.getFieldBlock('title').input)
            .on('change', function(e) {
                this._updateLengthCounter('title', e.block.val(), u.consts('NEW_MAX_TITLE_LENGTH_MOBILE'));
            }, this)
            .on('blur', function() {
                this._getGeoRestrictions();
            }, this);

        this._subscriptionManager.wrap(this.getFieldBlock('body').input)
            .on('change', function(e) {
                this._updateLengthCounter('body', e.block.val(), u.consts('MAX_BODY_LENGTH_MOBILE'));
            }, this)
            .on('blur', function() {
                this._getGeoRestrictions();
            }, this);

        this._subscriptionManager
            .on(this._geoModel, 'change', this._getGeoRestrictions, this)
            .on(this.model, 'body', 'change', function() {
                if (!this.getFieldBlock('body').input.hasMod('focused')) {
                    this._getGeoRestrictions();
                }
            }, this)
            .on(this.model, 'reflected_attrs', 'change', function() {
                this._toggleCurrencyWarning();
            }, this);

        // при инициации preview-warning нужно попытаться показать предупреждение о валюте
        // актуально при добавлении нового баннера с неподдерживаемой валютой
        // так как сначала добавляется баннер, а потом инициализируются предупреждения
        this._subscriptionManager.on(this.bannerDM, 'warnings-blocks-inited', function() {
            this._toggleCurrencyWarning();
        }, this);

        this._subscriptionManager.on(mobileContentModel, 'isCurrencySupported', 'change', function() {
            this._toggleCurrencyWarning();
        }, this);

        this._subscriptionManager
            .on(this.model, 'ad_type', 'change', this._changeBannerAdType, this);

        this._imageAdLoader && this._bindImageAdEvents();
        this._bindVideoExtensionEvents();
    },

    /**
     * Подписывается на события модели графического объявления
     * @private
     */
    _bindImageAdEvents: function() {
        this._subscriptionManager.wrap(this.model)
            .on('ad_type', 'clear', function() {
                this._imageAdLoader.resetImage();
            }, this)
            .on('image_ad', 'update', function() {
                this._imageAdLoader.setImage(this.model.get('image_ad').toJSON());
            }, this)
            .on('creative', 'update', function() {
                this._imageAdLoader.setCreative(this.model.get('creative').toJSON());
            }, this);
    },

    /**
     * Удаляет текущий баннер
     * @private
     */
    _deleteBanner: function() {
        var handler = this._onRemoveRequest.bind(this);

        if (this.model.isChanged()) {
            BEM.blocks['b-confirm'].open({
                message: iget2('b-edit-banner2', 'vy-deystvitelno-hotite-udalit', 'Вы действительно хотите удалить объявление?'),
                onYes: handler
            }, this);
        } else {
            handler();
        }
    },

    /**
     * Очищает тексты в объявлении
     * @private
     */
    _clearText: function() {
        var mobileAppTrackerHref = this.model.get('mobileAppTrackerHref'),
            mobileContent = this.model.getMobileContentForGroup(),
            reflectedAttrs = this.params.campaign.selected_mobile_app ?
                this.bannerDM.getGroup().get('displayedAttributes') :
                u['dm-mobile-content'].getAvailableAttrs(mobileContent);

        this.model.update({
            title: '',
            body: '',
            href: mobileAppTrackerHref,
            reflected_attrs: reflectedAttrs,
            video_resources: {}
        }, {
            action: 'clear'
        });

        //метрика
        try {
            yaCounter191494.reachGoal('CLEAR_TEXT');
        } catch (e) { }

        this.model.get('image_model').clear();
        this.model.get('href_model').clear();
        this.model.get('sitelinks').clear();
        this.model.clear('ad_type');
        this.model.get('image_ad').clear();
        this.model.get('creative').clear();
        this.bannerDM.clear('imageSize');
    },

    /**
     * Обновляет значение счетчика оставшихся символов
     * @param {String} name
     * @param {String} val
     * @param {Number} limit
     * @private
     */
    _updateLengthCounter: function(name, val, limit) {
        var counter = this.elem(name + '-length-counter'),
            counterValue;

        val = u.preview.skipSharpSign(val);

        counterValue = limit - (val.length || 0);

        counter.text(counterValue);

        this.toggleMod(counter, 'under-zero', 'yes', counterValue < 0);
    },

    /**
     * Возвращает промис ограничения по паре текст/регионы
     * @returns {Object}
     * @private
     */
    _getGeoRestrictions: function() {
        var _this = this,
            text = this.model.get('body') + this.model.get('title'),
            adType = this.model.get('ad_type');

        if (adType === 'image_ad' || adType === 'cpc_video') {
            this._geoRestrictionsRequest.abort();

            this.model.getDM()['dm-mobile-content-banner'].trigger('geo-check-error', { messages: '' });

            return;
        }

        this._geoRestrictionsRequest.get({
            text: text,
            geo: this._geoModel.get('geo')
        }, function(data) {
            var warning;

            if (data.warning) {
                warning = data.warning;
            } else if (data.error) {
                warning = data.error.for_banner;
            }

            _this.model.getDM()['dm-mobile-content-banner'].trigger('geo-check-error', { messages: warning });
        }, function() {
            _this.model.getDM()['dm-mobile-content-banner'].trigger('geo-check-error', { messages: '' });
        });

        return this;
    },

    /**
     * Переключает предупреждение о неподдерживаемой валюте
     * @private
     */
    _toggleCurrencyWarning: function() {
        var dm = this.model.getDM()['dm-mobile-content-banner'],
            isCurrencySupported = this.model.getMobileContentModelForGroup().get('isCurrencySupported');

        dm.trigger('currency-check-error', {
            messages: isCurrencySupported ||
                this.model.get('reflected_attrs').indexOf('price') == -1 || dm.get('ad_type') == 'image_ad' ?
                [] :
                [iget2(
                    'b-edit-banner2',
                    'cena-ne-otobrazhaetsya-t',
                    'Цена не отображается, т.к. указана ссылка на приложение с неподдерживаемой валютой'
                )]
        });
    },

    /**
     * Меняет вид формы в соответсвии с выбранным типом объявления баннера
     * @private
     */
    _changeBannerAdType: function() {
        var adType = this.model.get('ad_type');

        this.setMod('ad-type', u.beminize(adType));

        this._bannerViewer.setMod(
            'current-view',
            adType === 'image_ad' ?
                'base-image' :
                adType === 'cpc_video' ? 'creative' : 'edit'
        );

        // для графических баннеров предупреждение о ограничении текст-регион показывать не нужно
        // поэтому текст ограничения нужно обновлять при смене типа баннера
        this._getGeoRestrictions();

        // для ГО нет подсказки
        this._toggleCurrencyWarning();
    },

    /**
     * Передает внутренним блокам новое доступное для добавления количество баннеров
     * @override {b-edit-banner2}
     * @param {Number} count - доступное для добавления количество баннеров
     */
    updateAvailableBannerCount: function(count) {
        this._imageAdLoader && this._imageAdLoader.updateAvailableBannerCount(count);
    },

    /**
     * Инициализирует контрол для загрузки графического объявления
     * @return {BEM.DOM<b-image-add-loader>|undefined} блок для загрузки файла изображения для графического объявления
     * @private
     */
    _initImageAdLoader: function() {

        var imageAdLoader = this.findBlockOn('image-ad-loader', 'b-image-add-loader');

        if (imageAdLoader) {

            this._subscriptionManager
                .on(imageAdLoader, '_loading_*', this._onLoadingImages, this)
                .on(imageAdLoader, 'change:creatives', function(e, data) {
                    var href = data.href || {},
                        creatives = data.creatives || data.images,
                        image = data.images && data.images[0],
                        creative = data.creatives && data.creatives[0];

                    if ((data.images || []).length) {
                        this.model.clear('creative');
                        this.model.get('image_ad').update(image);
                        this.bannerDM.set('imageSize', u.imageAd.imageSizeToString(image.width, image.height));
                    }

                    if ((data.creatives || []).length) {
                        this.model.clear('image_ad');
                        this.model.get('creative').update(creative);
                        this.bannerDM.set('imageSize', u.imageAd.imageSizeToString(creative.width, creative.height));
                    }

                    // если выбрано более 1 креатива, добавляем новые баннеры
                    if (creatives.length > 1) {
                        this.model.update({
                            href: href.href || '',
                            domain: href.href_domain || '',
                            url_protocol: href.protocol || ''
                        });

                        this.trigger(
                            'new:banners:needed',
                            creatives.slice(1).map(function(el) {
                                var newBannerData = { ad_type: 'image_ad' };

                                data.images && (newBannerData.image_ad = el);
                                data.creatives && (newBannerData.creative = el);

                                if (href.href) {
                                    newBannerData.href = href.href;
                                    newBannerData.domain = href.href_domain;
                                    newBannerData.url_protocol = href.protocol;
                                }

                                return newBannerData;
                            })
                        );
                    } else {
                        href.href && this.model.update({
                            href: href.href,
                            domain: href.href_domain,
                            url_protocol: href.protocol
                        });
                    }

                    if (data.errors) {
                        BEM.blocks['b-confirm'].open({
                            message: data.errors,
                            type: 'alert',
                            title: data.errors.length > 1 ?
                                iget2('b-edit-banner2', 'title-errors-upload-images', 'Следующие файлы не были загружены') :
                                iget2('b-edit-banner2', 'title-errors-upload-image', 'Файл не был загружен'),
                            withBullets: data.errors.length > 1
                        });
                    }
                }, this)
                .on(imageAdLoader, 'ready', function(e, data) {
                    var bannerStorage = data.bannerStorage,
                        bannerPreview2 = this.findBlockInside('b-banner-preview2');

                    if (bannerPreview2) {
                        bannerStorage.postMessage({
                            type: 'video-addition-preview',
                            data: u['b-banner-preview2'].getVideoPreviewPostMessage(bannerPreview2.getCtxData())
                        })
                    }
                }, this);
        }

        return imageAdLoader;
    },

    destruct: function() {
        this.unbindFrom('clear-text', 'click', this._clearText);

        this.bannerDM.clear('imageSize');

        this.model && this.model.destruct();

        return this.__base.apply(this, arguments);
    }
});
