BEM.MODEL.decl({ name: 'b-edit-banner2_type_mobile-content', baseModel: 'vm-sync-dm2' }, {

    /**
     * декларация DM модели
     */
    _dmDecl: {
        type: 'object',
        internal: true,
        calculate: function() {
            return {
                'dm-mobile-content-banner': {
                    name: 'dm-mobile-content-banner',
                    id: this.id
                }
            };
        }
    },

    modelId: 'string',

    bid: 'number',

    // тип действия на кнопке в баннере
    actionType: {
        type: 'string',
        default: 'download'
    },

    ad_type: {
        type: 'enum',
        default: 'text',
        enum: [
            'text',
            'image_ad',
            'cpc_video'
        ]
    },

    image_ad: {
        type: 'model',
        modelName: 'dm-image-ad'
    },

    creative: {
        type: 'model',
        modelName: 'dm-creative'
    },

    // данные медиа дополнений для баннера
    video_resources: 'extended-object',

    // для баннера запрещены видеодополнения по умолчанию
    disable_videomotion: 'boolean',

    title: 'string',
    body: 'string',

    // поля для синхронизации с DM
    reflected_attrs: 'array',
    url_protocol: 'string',
    href: 'string',

    sitelinks: {
        type: 'model',
        modelName: 'm-banner-sitelinks',
        validation: {
            rules: {
                'href-required': {
                    validate: function() {
                        return !(this.get('href_model').isEmpty('href') && !this.get('sitelinks').isEmpty());
                    },

                    text: iget2(
                        'b-edit-banner2',
                        'esli-zapolneny-bystrye-ssylki',
                        'Если заполнены быстрые ссылки, то должна быть заполнена основная ссылка на сайт'
                    )
                }
            }
        }
    },

    image_model: {
        type: 'model',
        modelName: 'm-banner-pic'
    },

    //используется в b-group-preview__item.bemhtml -  понять, чем отличается от isArchived
    archive: 'string',
    geo_names: 'string',
    declined_show: 'boolean',
    child_age: { type: 'number', value: 11 },

    baby_food_enabled: 'boolean',

    domain: 'string',

    //---Модерация
    //Баннер скопирован в оптимизированные
    isStatusOptimized: 'boolean',
    //Баннер отклонен модератором
    isRejectByModerator: 'boolean',
    autobudget: 'string',
    status: 'string',
    statusAutobudgetShow: 'string',
    statusShow: 'string',
    groupStatusModerate: 'string',
    statusModerate: 'string',
    day_budget: 'string',
    enable: 'boolean',

    canToggleAge: 'boolean',
    //идет создание нового баннера
    isNewBanner: {
        type: 'boolean',
        internal: true
    },
    newBannerIndex: { type: 'number', internal: true },
    //имеет ссылку "скопировать из предыдущего"
    hasCopyFromPrev: { type: 'boolean', internal: true },
    showAdminAttrs: { type: 'boolean', internal: true },

    // возрастные ограничения для баннера
    ageLabel: {
        type: 'enum',
        enum: [
            '0+',
            '6+',
            '12+',
            '16+',
            '18+'
        ],
        mapping: {
            from: function() {
                var flags = this.getDM()['dm-mobile-content-banner'].get('hash_flags');

                return (flags && flags.age || '18') + '+';
            },
            to: function() {
                var dm = this.getDM()['dm-mobile-content-banner'],
                    age = this.get('ageLabel'),
                    flags = dm.get('hash_flags') ? u._.extend({}, dm.get('hash_flags')) : {};

                flags.age = age.substring(0, age.length - 1);

                return flags;
            }
        }
    },

    // alkaline@todo убрать подписку из превью?
    // выпилить после поддержки в превью разных типов баннеров
    has_href: {
        type: 'boolean',
        calculate: function() {
            return this.get('domain');
        },
        dependsFrom: ['domain']
    },
    href_model: {
        type: 'model',
        modelName: 'm-banner-href',

        value: {}
    },

    usedResolutions: 'array',

    hideSizeAdviser: {
        type: 'boolean',
        default: true
    },

    allFormatsSizeAdviserUsed: {
        type: 'boolean',
        default: false
    },

    mobileAppTrackerHref: {
        type: 'string',
        default: ''
    }
}, {

    init: function() {
        var dm = this.getDM()['dm-mobile-content-banner'],
            ageLabelField = this.fieldsDecl.ageLabel,
            dmGroup = dm.getGroup();

        this.__base.apply(this, arguments);

        this.glueToDM([
            'title',
            'body',
            'reflected_attrs',
            'image_model',
            'url_protocol',
            'image_ad',
            'creative',
            'ad_type',
            'disable_videomotion',
            'video_resources',
            'href'
        ]);

        this.set('ageLabel', ageLabelField.mapping.from.call(this));

        dm.on('hash_flags', 'change', function() {
            this.set('ageLabel', ageLabelField.mapping.from.call(this));
        }, this);

        this.set('usedResolutions', dmGroup.get('usedResolutions'));
        dmGroup.on('usedResolutions', 'change', function() {
            this.set('usedResolutions', dmGroup.get('usedResolutions'));
        }, this);

        if (!dm.get('imageSize') && !this.get('allFormatsSizeAdviserUsed')) {
            this.set('hideSizeAdviser', !!dm.get('imageSize'));
        }

        dm.on('imageSize', 'change', function() {
            this.set('hideSizeAdviser', !!dm.get('imageSize'));
        }, this);

        this.on('ageLabel', 'change', function() {
            var value = ageLabelField.mapping.to.call(this);

            dm.set('hash_flags', value);
        }, this);

        this.trigger('ageLabel', 'change', { value: this.get('ageLabel') });

        this.set('actionType', dm.get('primary_action'));
        this.on('actionType', 'change', function(e, data) {
            dm.set('primary_action', data.value);
        });

        dm.on('destruct', function() {
            this.destruct();
        }, this);
        this.fix();
    },

    /**
     * Возвращает данные, необходимые для отрисовки ошибок в хедере
     * @returns {Object}
     */
    toJSONForErrors: function() {
        var res = {};

        ['isNewBanner', 'newBannerIndex', 'bid', 'modelId'].forEach(function(name) {
            res[name] = this.get(name);
        }, this);

        return res;
    },

    /**
     * Связывает изменения полей в моделях
     * @param {Array} fields список полей для связки
     * @private
     */
    glueToDM: function(fields) {
        var dm = this.getDM()['dm-mobile-content-banner'];

        fields.forEach(function(field) {
            dm.on(field, 'change', function() {
                (field === 'image_model' || field === 'image_ad' || field === 'creative') ?
                    this.get(field).update(dm.get(field).toJSON()) :
                    this.set(field, dm.get(field, 'formatted'));
            }, this);

            this.on(field, 'change', function() {
                (field === 'image_model' || field === 'image_ad' || field === 'creative') ?
                    dm.get(field).update(this.get(field).toJSON()) :
                    dm.set(field, this.get(field));
            }, this);

        }, this);
    },

    /**
     * Возвращает данные "мобильного контента" для группы
     * @returns {Object}
     */
    getMobileContentForGroup: function() {
        return this.getMobileContentModelForGroup().toJSON();
    },

    /**
     * Возвращает модель мобильного контента для группы
     * @returns {*}
     */
    getMobileContentModelForGroup: function() {
        var dm = this.getDM()['dm-mobile-content-banner'];

        return dm.getGroup().get('mobile_content');
    }
});
